/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.model.settings.configuration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class YamlPropertySourceFactory
implements PropertySourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlPropertySourceFactory.class);

    public PropertySource<?> createPropertySource(String name, EncodedResource encodedResource) throws IOException {
        if (encodedResource == null || encodedResource.getResource() == null) {
            throw new IllegalArgumentException("The encodedResource must be available.");
        }
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{encodedResource.getResource()});
        Properties properties = null;
        try {
            properties = factory.getObject();
        }
        catch (IllegalStateException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                LOGGER.info("Ignore file not found exception: {}", (Object)ex.getCause().getMessage());
                properties = new Properties();
            }
            LOGGER.warn("Get properties failed.", (Throwable)ex);
            throw ex;
        }
        return new PropertiesPropertySource(encodedResource.getResource().getFilename(), properties);
    }
}

