/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.event.NodeStatusEvent;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.event.PortConfigEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPortHandler<T extends Port<?>> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected List<T> ports = new LinkedList<T>();
    protected final NodeInterface node;
    protected boolean portsProcessed;
    private final Class<T> portClazz;
    private final ConnectionNodeAwarePublisher publisher;
    private final WizardLabelWrapper wizardLabelWrapper;

    public AbstractPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        this.node = node;
        this.publisher = publisher;
        this.portClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.wizardLabelWrapper = wizardLabelWrapper;
    }

    protected ConnectionNodeAwarePublisher getPublisher() {
        return this.publisher;
    }

    protected final WizardLabelWrapper getWizardLabelWrapper() {
        return this.wizardLabelWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPorts(NodeChangePublisher nodeChangePublisher) {
        List<T> list = this.ports;
        synchronized (list) {
            this.LOGGER.info("Clear the ports.");
            this.ports.clear();
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(this.portClazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPorts() {
        this.LOGGER.debug("Check if ports are available.");
        List<T> list = this.ports;
        synchronized (list) {
            return CollectionUtils.isNotEmpty(this.ports);
        }
    }

    public abstract void setPorts(List<T> var1, NodeChangePublisher var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getPorts(NodeChangePublisher nodeChangePublisher) {
        List cachedPorts = Collections.emptyList();
        if (this.node.isFlatPortModel()) {
            ArrayList<GenericPort> genericPorts;
            boolean fireChanged = false;
            ArrayList<GenericPort> arrayList = genericPorts = new ArrayList<GenericPort>(this.node.getGenericPorts());
            synchronized (arrayList) {
                List<T> list = this.ports;
                synchronized (list) {
                    if (NodeStatusEvent.StatusIdentifier.InitialLoadFinished != this.node.getNodeLoadStatusIdentifier()) {
                        this.LOGGER.info("Clear and rebuild the ports cache. Current node load status: {}, node: {}", (Object)this.node.getNodeLoadStatusIdentifier(), (Object)this.node);
                        this.ports.clear();
                        this.cachePorts(genericPorts);
                        fireChanged = true;
                    } else if (this.ports.isEmpty()) {
                        this.LOGGER.info("No cached ports available.");
                        this.cachePorts(genericPorts);
                        if (!this.ports.isEmpty()) {
                            fireChanged = true;
                        }
                    } else {
                        this.LOGGER.info("Return the cached {} ports, portsProcessed: {}", (Object)this.portClazz.getSimpleName(), (Object)this.portsProcessed);
                    }
                    if (NodeStatusEvent.StatusIdentifier.InitialLoadFinished == this.node.getNodeLoadStatusIdentifier()) {
                        this.LOGGER.info("Set the portsProcessed flag to true for node: {}", (Object)this.node);
                        this.portsProcessed = true;
                    }
                    cachedPorts = Collections.unmodifiableList(this.ports);
                }
            }
            if (fireChanged && NodeStatusEvent.StatusIdentifier.InitialLoadFinished == this.node.getNodeLoadStatusIdentifier()) {
                this.LOGGER.info("Fire that the ports have changed.");
                nodeChangePublisher.firePortListChanged(this.portClazz);
            }
        } else {
            this.LOGGER.debug("The current node supports the type-oriented port model: {}", (Object)this.node);
            cachedPorts = Collections.unmodifiableList(this.ports);
        }
        return cachedPorts;
    }

    protected abstract void cachePorts(List<GenericPort> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig, NodeChangePublisher nodeChangePublisher) {
        try {
            Port port = null;
            List<T> list = this.ports;
            synchronized (list) {
                List<T> currentPorts = this.getPorts(nodeChangePublisher);
                if (CollectionUtils.isNotEmpty(currentPorts) && (port = PortListUtils.findPortByPortNumber(currentPorts, (int)portNumber)) != null && portConfig != null) {
                    port.setPortConfigX(portConfig);
                }
            }
            if (port != null) {
                Port portToNotify = port;
                nodeChangePublisher.firePortConfigChanged(portToNotify);
                this.getPublisher().getSubjectPortEvents().onNext((Object)new PortConfigEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), (PortTypeAware)port));
            }
        }
        catch (Exception ex) {
            this.LOGGER.warn("Set port config failed for portNumber: {}, portType: {}", new Object[]{portNumber, this.portClazz, ex});
        }
    }

    public abstract List<T> getEnabledPorts();

    public boolean hasPendingPortStatus() {
        for (Port port : this.getEnabledPorts()) {
            if (port.getStatus() != null) continue;
            return true;
        }
        return false;
    }
}

