/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogPortHandler
extends AbstractPortHandler<AnalogPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalogPortHandler.class);

    public AnalogPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<AnalogPort> analogPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the analog ports on the node: {}", analogPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(analogPorts)) {
                this.ports.addAll(analogPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.analogPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(AnalogPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.debug("Prepare the analog ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsAnalogPort()) {
                LOGGER.trace("The current port supports analog port: {}", (Object)genericPort);
                AnalogPort analogPort = new AnalogPort(genericPort);
                analogPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(analogPort);
                continue;
            }
            LOGGER.trace("The current port does not support analog port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.analogPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnalogPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<AnalogPort> enabledPorts = new LinkedList<AnalogPort>();
            for (AnalogPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }
}

