/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortStatusEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightPortHandler
extends AbstractPortHandler<BacklightPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortHandler.class);

    public BacklightPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<BacklightPort> backlightPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the backlight ports on the node: {}", backlightPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(backlightPorts)) {
                this.ports.addAll(backlightPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.backlightPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(BacklightPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.debug("Prepare the backlight ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsBacklightPort()) {
                LOGGER.trace("The current port supports backlight port: {}", (Object)genericPort);
                BacklightPort backlightPort = new BacklightPort(genericPort);
                backlightPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(backlightPort);
                continue;
            }
            LOGGER.trace("The current port does not support backlight port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.backlightPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BacklightPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<BacklightPort> enabledPorts = new LinkedList<BacklightPort>();
            for (BacklightPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortValue(int portNumber, int portValue, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the backlight port value: {}, portNumber: {}", (Object)portValue, (Object)portNumber);
        BacklightPort port = null;
        boolean portConfigChanged = false;
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                GenericPort genericPort = PortListUtils.findGenericPortByPortNumber((List)this.node.getGenericPorts(), (int)portNumber);
                if (genericPort != null && genericPort.isSupportsBacklightPort()) {
                    LOGGER.info("The current port supports backlight port: {}", (Object)genericPort);
                    genericPort.setPortValue(Integer.valueOf(portValue));
                    if (genericPort.isInactive()) {
                        genericPort.setInactive(false);
                        portConfigChanged = true;
                    }
                    port = new BacklightPort(genericPort);
                } else {
                    LOGGER.info("No generic port found or the current generic port does not support backlight port, port number: {}, port: {}", (Object)portNumber, (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    BacklightPort backlightPort = (BacklightPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (backlightPort != null) {
                        Integer oldValue = backlightPort.getValue();
                        if (oldValue == null || oldValue != portValue || backlightPort.getExpectedTargetValue() != null && backlightPort.getExpectedTargetValue() > -1) {
                            backlightPort.setValue(Integer.valueOf(portValue), true);
                            LOGGER.debug("BacklightPort value has changed, port: {}, value: {}", (Object)backlightPort, (Object)portValue);
                            port = backlightPort;
                        }
                    } else {
                        LOGGER.warn("No backlight port available for portNumber: {}", (Object)portNumber);
                    }
                } else {
                    LOGGER.debug("No backlight ports or generic ports available.");
                }
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortValueChanged(BacklightPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            this.getPublisher().getSubjectPortEvents().onNext((Object)new PortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }
}

