/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.base.Objects;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.event.NodeActionEvent;
import org.bidib.wizard.api.model.listener.BoosterStatusListener;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.status.BoosterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterNode
extends Model
implements BoosterNodeInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterNode.class);
    public static final String PROPERTY_BOOSTER_STATUS = "boosterStatus";
    private Integer boosterCurrent;
    private Long lastCurrentUpdate;
    private Integer boosterMaximumCurrent;
    private BoosterStatus boosterStatus;
    private Integer boosterTemperature;
    private Integer boosterVoltage;
    private BoosterControl boosterControl = BoosterControl.NONE;
    private Collection<BoosterStatusListener> boosterStatusListeners = new LinkedList<BoosterStatusListener>();
    private final WeakReference<NodeInterface> parent;
    private final ConnectionNodeAwarePublisher publisher;
    private PublishSubject<BoosterStatus> subjectBoosterStatus;

    public BoosterNode(NodeInterface parent, ConnectionNodeAwarePublisher publisher) {
        this.parent = new WeakReference<NodeInterface>(parent);
        this.publisher = publisher;
        this.subjectBoosterStatus = PublishSubject.create();
    }

    public NodeInterface getNode() {
        return (NodeInterface)this.parent.get();
    }

    public void addBoosterStatusListener(BoosterStatusListener listener) {
        this.boosterStatusListeners.add(listener);
    }

    public void removeBoosterStatusListener(BoosterStatusListener listener) {
        this.boosterStatusListeners.remove(listener);
    }

    public void setBoosterCurrent(Integer current, long timestamp) {
        this.setLastCurrentUpdate(System.currentTimeMillis());
        LOGGER.debug("Booster current has changed, new: {}, old: {}, timestamp: {}", new Object[]{current, this.boosterCurrent, timestamp});
        this.boosterCurrent = current;
        this.fireBoosterCurrentChanged(current, timestamp);
    }

    public Integer getBoosterCurrent() {
        return this.boosterCurrent;
    }

    public void setBoosterMaximumCurrent(Integer maximumCurrent) {
        LOGGER.info("Set the new maximum current value: {}, previous: {}", (Object)maximumCurrent, (Object)this.boosterMaximumCurrent);
        this.boosterMaximumCurrent = maximumCurrent;
        this.fireBoosterMaximumCurrentChanged(maximumCurrent);
    }

    public Integer getBoosterMaximumCurrent() {
        return this.boosterMaximumCurrent;
    }

    public void fetchMaxBoosterCurrent() {
        try {
            Feature feature = Feature.findFeature((Collection)this.getNode().getNode().getFeatures(), (int)22);
            if (feature != null) {
                int maxBoosterCurrent = 0;
                maxBoosterCurrent = ConversionUtils.convertCurrent((int)feature.getValue());
                LOGGER.info("Fetched the maximum current value from the booster: {} mA, uniqueId: {}", (Object)maxBoosterCurrent, (Object)ByteUtils.getUniqueIdAsString((long)this.getNode().getUniqueId()));
                this.setBoosterMaximumCurrent(maxBoosterCurrent);
            } else {
                LOGGER.info("The feature FEATURE_BST_AMPERE is not available.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get FEATURE_BST_AMPERE from node failed.", (Throwable)ex);
        }
    }

    public BoosterStatus getBoosterStatus() {
        return this.boosterStatus;
    }

    public Integer getBoosterTemperature() {
        return this.boosterTemperature;
    }

    public Integer getBoosterVoltage() {
        return this.boosterVoltage;
    }

    public Long getLastCurrentUpdate() {
        return this.lastCurrentUpdate;
    }

    public void setLastCurrentUpdate(Long lastCurrentUpdate) {
        this.lastCurrentUpdate = lastCurrentUpdate;
    }

    public void setBoosterStatus(BoosterStatus status) {
        LOGGER.info("Set the new booster status: {}", (Object)status);
        BoosterStatus oldValue = this.boosterStatus;
        this.boosterStatus = status;
        LOGGER.info("Fire booster status changed: {}", (Object)status);
        this.fireBoosterStatusChanged(status);
        this.firePropertyChange(PROPERTY_BOOSTER_STATUS, oldValue, this.boosterStatus);
    }

    public void setBoosterTemperature(Integer temperature) {
        if (!Objects.equals((Object)temperature, (Object)this.boosterTemperature)) {
            this.boosterTemperature = temperature;
            this.fireBoosterTemperatureChanged(temperature);
        }
    }

    public void setBoosterVoltage(Integer voltage) {
        if (!Objects.equals((Object)voltage, (Object)this.boosterVoltage)) {
            this.boosterVoltage = voltage;
            this.fireBoosterVoltageChanged(voltage);
        }
    }

    public BoosterControl getBoosterControl() {
        return this.boosterControl;
    }

    public void setBoosterControl(BoosterControl boosterControl) {
        LOGGER.info("Set the new boosterControl value: {}", (Object)boosterControl);
        BoosterControl oldValue = this.boosterControl;
        this.boosterControl = boosterControl;
        this.fireBoosterControlChanged(boosterControl);
        this.firePropertyChange("boosterControl", oldValue, this.boosterControl);
    }

    public void updateBoosterControl(AccessoryState accessoryState) {
        LOGGER.info("Update the booster control, accessoryState: {}", (Object)accessoryState);
        BoosterControl boosterControl = null;
        if (accessoryState != null && !accessoryState.hasError()) {
            Integer activeAspect = accessoryState.getActiveAspect();
            boosterControl = BoosterControl.valueOf((byte)ByteUtils.getLowByte((Integer)activeAspect));
        }
        if (boosterControl == null) {
            LOGGER.warn("The booster control is not available. Use NONE as state.");
            boosterControl = BoosterControl.NONE;
        }
        this.setBoosterControl(boosterControl);
    }

    private void fireBoosterControlChanged(BoosterControl control) {
        for (BoosterStatusListener l : this.boosterStatusListeners) {
            l.controlChanged((NodeInterface)this.parent.get(), control);
        }
        this.publisher.getSubjectNodeEvents().onNext((Object)this.buildBoosterControlEvent());
    }

    private void fireBoosterMaximumCurrentChanged(Integer maximumCurrent) {
        for (BoosterStatusListener l : this.boosterStatusListeners) {
            l.maximumCurrentChanged((NodeInterface)this.parent.get(), maximumCurrent);
        }
        this.publisher.getSubjectNodeEvents().onNext((Object)this.buildBoosterDiagEvent());
    }

    private void fireBoosterStatusChanged(BoosterStatus status) {
        for (BoosterStatusListener l : this.boosterStatusListeners) {
            l.stateChanged((NodeInterface)this.parent.get(), status);
        }
        if (status != null) {
            LOGGER.debug("Publish the changed command station state: {}", (Object)status);
            this.subjectBoosterStatus.onNext((Object)status);
        }
        this.publisher.getSubjectNodeEvents().onNext((Object)this.buildBoosterStatusEvent());
    }

    private void fireBoosterTemperatureChanged(Integer temperature) {
        for (BoosterStatusListener l : this.boosterStatusListeners) {
            l.temperatureChanged((NodeInterface)this.parent.get(), temperature);
        }
        this.publisher.getSubjectNodeEvents().onNext((Object)this.buildBoosterDiagEvent());
    }

    private void fireBoosterVoltageChanged(Integer voltage) {
        for (BoosterStatusListener l : this.boosterStatusListeners) {
            l.voltageChanged((NodeInterface)this.parent.get(), voltage);
        }
        this.publisher.getSubjectNodeEvents().onNext((Object)this.buildBoosterDiagEvent());
    }

    private void fireBoosterCurrentChanged(Integer current, long timestamp) {
        for (BoosterStatusListener l : this.boosterStatusListeners) {
            l.currentChanged((NodeInterface)this.parent.get(), current, timestamp);
        }
        this.publisher.getSubjectNodeEvents().onNext((Object)this.buildBoosterDiagEvent());
    }

    private NodeActionEvent buildBoosterDiagEvent() {
        NodeActionEvent boosterDiagEvent = new NodeActionEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeActionEvent.ActionIdentifier.BoosterDiag);
        return boosterDiagEvent;
    }

    private NodeActionEvent buildBoosterStatusEvent() {
        NodeActionEvent boosterStatusEvent = new NodeActionEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeActionEvent.ActionIdentifier.BoosterStatus);
        return boosterStatusEvent;
    }

    private NodeActionEvent buildBoosterControlEvent() {
        NodeActionEvent boosterStatusEvent = new NodeActionEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeActionEvent.ActionIdentifier.BoosterControl);
        return boosterStatusEvent;
    }

    public Disposable subscribeSubjectBoosterState(Consumer<BoosterStatus> onNext, Consumer<Throwable> onError, Action onComplete) {
        LOGGER.info("Subscribe to subjectBoosterStatus, consumer: {}", onNext);
        Disposable disposable = this.subjectBoosterStatus.subscribeOn(Schedulers.trampoline()).observeOn(Schedulers.computation()).subscribe(onNext, onError, onComplete);
        return disposable;
    }
}

