/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import com.jgoodies.binding.beans.Model;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.event.NodeActionEvent;
import org.bidib.wizard.api.model.listener.CommandStationStatusListener;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandStationNode
extends Model
implements CommandStationNodeInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandStationNode.class);
    public static final String PROPERTY_COMMANDSTATION_STATE = "commandStationState";
    public static final String PROPERTY_COMMANDSTATION_PROG_STATE = "commandStationProgState";
    public static final String PROPERTY_DCCADV_AVAILABLE = "dccAdvAvailable";
    private CommandStationStatus commandStationState;
    private CommandStationProgState commandStationProgState;
    private Collection<CommandStationStatusListener> commandStationStatusListeners = new LinkedList<CommandStationStatusListener>();
    private final WeakReference<NodeInterface> parent;
    private PublishSubject<CommandStationStatus> subjectCommandStationState;
    private PublishSubject<CommandStationProgState> subjectCommandStationProgState;
    private final ConnectionNodeAwarePublisher publisher;
    private Boolean dccAdvAvailable = Boolean.FALSE;

    public CommandStationNode(NodeInterface parent, ConnectionNodeAwarePublisher publisher) {
        this.parent = new WeakReference<NodeInterface>(parent);
        this.publisher = publisher;
        this.subjectCommandStationState = PublishSubject.create();
        this.subjectCommandStationProgState = PublishSubject.create();
    }

    public NodeInterface getNode() {
        return (NodeInterface)this.parent.get();
    }

    public void addCommandStationStatusListener(CommandStationStatusListener commandStationStatusListener) {
        if (!this.commandStationStatusListeners.contains(commandStationStatusListener)) {
            this.commandStationStatusListeners.add(commandStationStatusListener);
        } else {
            LOGGER.warn("Command station listener to add is already registered: {}", (Object)commandStationStatusListener);
        }
    }

    public void removeCommandStationStatusListener(CommandStationStatusListener commandStationStatusListener) {
        if (this.commandStationStatusListeners.contains(commandStationStatusListener)) {
            this.commandStationStatusListeners.add(commandStationStatusListener);
        } else {
            LOGGER.warn("Command station listener to remove is not registered: {}", (Object)commandStationStatusListener);
        }
    }

    public Disposable subscribeSubjectCommandStationState(Consumer<CommandStationStatus> onNext, Consumer<Throwable> onError, Action onComplete) {
        LOGGER.info("Subscribe to subjectCommandStationState, consumer: {}", onNext);
        Disposable disposable = this.subjectCommandStationState.subscribeOn(Schedulers.trampoline()).observeOn(Schedulers.computation()).subscribe(onNext, onError, onComplete);
        return disposable;
    }

    public Disposable subscribeSubjectCommandStationProgState(Consumer<CommandStationProgState> onNext, Consumer<Throwable> onError) {
        Disposable disposable = this.subjectCommandStationProgState.subscribeOn(Schedulers.trampoline()).subscribe(onNext, onError);
        return disposable;
    }

    public CommandStationStatus getCommandStationStatus() {
        return this.commandStationState;
    }

    public void setCommandStationStatus(CommandStationStatus commandStationState) {
        LOGGER.info("Set the new command station state: {}", (Object)commandStationState);
        CommandStationStatus oldValue = this.commandStationState;
        this.commandStationState = commandStationState;
        this.fireCommandStationStatusChanged((NodeInterface)this.parent.get(), commandStationState);
        this.firePropertyChange(PROPERTY_COMMANDSTATION_STATE, oldValue, this.commandStationState);
    }

    private void fireCommandStationStatusChanged(NodeInterface node, CommandStationStatus state) {
        for (CommandStationStatusListener l : this.commandStationStatusListeners) {
            if (state == null) {
                LOGGER.warn("The command station status is not available. Use OFF as state.");
                state = CommandStationStatus.OFF;
            }
            try {
                l.statusChanged(node, state);
            }
            catch (Exception ex) {
                LOGGER.warn("Publish the the changed status failed, node: {}, csStatus: {}", new Object[]{node, state, ex});
            }
        }
        if (state != null) {
            LOGGER.debug("Publish the changed command station state: {}", (Object)state);
            this.subjectCommandStationState.onNext((Object)state);
        }
        LOGGER.debug("Publish the commandStationStatus as NodeActionEvent.");
        this.publisher.getSubjectNodeEvents().onNext((Object)this.buildCommandStationStatusEvent());
    }

    public CommandStationProgState getCommandStationProgState() {
        return this.commandStationProgState;
    }

    public void setCommandStationProgState(CommandStationProgState commandStationProgState) {
        LOGGER.info("Set the new command station prog state: {}", (Object)commandStationProgState);
        CommandStationProgState oldValue = this.commandStationProgState;
        this.commandStationProgState = commandStationProgState;
        this.fireCommandStationProgStatusChanged((NodeInterface)this.parent.get(), commandStationProgState);
        this.firePropertyChange(PROPERTY_COMMANDSTATION_PROG_STATE, oldValue, this.commandStationProgState);
    }

    private void fireCommandStationProgStatusChanged(NodeInterface node, CommandStationProgState state) {
        if (state != null) {
            this.subjectCommandStationProgState.onNext((Object)state);
        }
    }

    private NodeActionEvent buildCommandStationStatusEvent() {
        NodeActionEvent boosterStatusEvent = new NodeActionEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeActionEvent.ActionIdentifier.CommandStationStatus);
        return boosterStatusEvent;
    }

    public Boolean isDccAdvAvailable() {
        return this.dccAdvAvailable;
    }

    public void setDccAdvAvailable(Boolean dccAdvAvailable) {
        LOGGER.info("Set dccAdvAvailable: {}", (Object)dccAdvAvailable);
        Boolean oldValue = this.dccAdvAvailable;
        this.dccAdvAvailable = dccAdvAvailable;
        this.firePropertyChange(PROPERTY_DCCADV_AVAILABLE, oldValue, this.dccAdvAvailable);
    }
}

