/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.FeedbackConfidenceData;
import org.bidib.jbidibc.messages.FeedbackDynStateData;
import org.bidib.jbidibc.messages.FeedbackTimestampData;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.common.node.PropertyChangeConsumer;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.FeedbackPortStatusEvent;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.status.FeedbackConfidenceStatus;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPortHandler
extends AbstractPortHandler<FeedbackPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPortHandler.class);
    private final FeedbackPort globalDetectorPort = new FeedbackPort();
    private final FeedbackConfidenceStatus feedbackConfidenceStatus;

    public FeedbackPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
        this.globalDetectorPort.setId(255);
        this.feedbackConfidenceStatus = new FeedbackConfidenceStatus(0, 0, 0);
    }

    @Override
    public void clearPorts(NodeChangePublisher nodeChangePublisher) {
        LOGGER.debug("Do not clear port cache for feedback ports.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<FeedbackPort> feedbackPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the feedback ports on the node: {}", feedbackPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(feedbackPorts)) {
                this.ports.addAll(feedbackPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyFeedbackPortLabels(nodeLabels, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(FeedbackPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    public List<FeedbackPort> getPorts(NodeChangePublisher nodeChangePublisher) {
        return Collections.unmodifiableList(this.ports);
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
    }

    public FeedbackPort getGlobalDetectorFeedbackPort() {
        LOGGER.debug("Get the global detector feedback port.");
        return this.globalDetectorPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeedbackPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<FeedbackPort> enabledPorts = new LinkedList<FeedbackPort>();
            for (FeedbackPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortStatus(int portNumber, FeedbackPortStatus portState, Integer timestamp, NodeChangePublisher nodeChangePublisher) {
        FeedbackPort port = null;
        List list = this.ports;
        synchronized (list) {
            if (portNumber < this.ports.size()) {
                FeedbackPort feedbackPort = (FeedbackPort)this.ports.get(portNumber);
                LOGGER.debug("FeedbackPort status has changed, port: {}, status: {}, timestamp: {}", new Object[]{feedbackPort, portState, timestamp});
                feedbackPort.setStatus(portState);
                if (timestamp != null) {
                    feedbackPort.setTimestamp(new FeedbackTimestampData(timestamp.intValue()));
                }
                port = feedbackPort;
            } else {
                LOGGER.warn("No feedback port available for portNumber: {}", (Object)portNumber);
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortStatusChanged(FeedbackPort.class, port);
        }
        if (port != null) {
            this.getPublisher().getSubjectPortEvents().onNext((Object)new FeedbackPortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortAddresses(int portNumber, List<FeedbackAddressData> addresses, NodeChangePublisher nodeChangePublisher) {
        FeedbackPort port = null;
        FeedbackPort globalPort = null;
        List list = this.ports;
        synchronized (list) {
            FeedbackPort feedbackPort = (FeedbackPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
            if (feedbackPort != null) {
                LOGGER.debug("Addresses of feedbackPort has changed, port: {}, addresses: {}", (Object)feedbackPort, addresses);
                feedbackPort.setAddresses(addresses);
                port = feedbackPort;
            } else if (this.node.isGlobalDetectorAvailable()) {
                LOGGER.info("Feedback address event for global detector number: {}, addresses: {}", (Object)portNumber, addresses);
                List oldAddresses = this.globalDetectorPort.getAddresses();
                for (FeedbackAddressData address : addresses) {
                    Optional<FeedbackAddressData> oldAddress = oldAddresses.stream().filter(addr -> addr.getAddress() == address.getAddress()).findFirst();
                    if (!oldAddress.isPresent()) continue;
                    address.setSpeed(oldAddress.get().getSpeed());
                }
                this.globalDetectorPort.setAddresses(addresses);
                globalPort = this.globalDetectorPort;
            } else {
                LOGGER.warn("No feedback port available for portNumber: {}", (Object)portNumber);
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortIndexedPropertyChange((Port)port, "feedbackPortAddresses", port.getId(), null, addresses);
        }
        if (port != null) {
            this.getPublisher().getSubjectPortEvents().onNext((Object)new FeedbackPortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
        if (globalPort != null) {
            nodeChangePublisher.firePortIndexedPropertyChange(globalPort, "globalDetectorFeedbackPort", globalPort.getId(), null, addresses);
        }
        if (globalPort != null) {
            this.getPublisher().getSubjectPortEvents().onNext((Object)new FeedbackPortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), globalPort));
        }
    }

    public void setFeedbackPortGroupConfidence(FeedbackConfidenceStatus feedbackConfidenceStatus, NodeChangePublisher nodeChangePublisher, PropertyChangeConsumer<FeedbackConfidenceStatus, FeedbackConfidenceStatus> publisher) {
        FeedbackConfidenceStatus oldValue = new FeedbackConfidenceStatus(this.feedbackConfidenceStatus);
        this.feedbackConfidenceStatus.setInvalid(feedbackConfidenceStatus.getInvalid());
        this.feedbackConfidenceStatus.setFreeze(feedbackConfidenceStatus.getFreeze());
        this.feedbackConfidenceStatus.setNoSignal(feedbackConfidenceStatus.getNoSignal());
        List ports = this.node.getFeedbackPorts();
        int totalPorts = ports.size();
        int detectors = totalPorts / 16;
        int invalid = this.feedbackConfidenceStatus.getInvalid();
        int freeze = this.feedbackConfidenceStatus.getFreeze();
        int noSignal = this.feedbackConfidenceStatus.getNoSignal();
        LOGGER.info("Change confidence on feedback ports: {}, num of detectors: {}, node: {}", new Object[]{totalPorts, detectors, this.node});
        for (int portNumber = 0; portNumber < totalPorts; ++portNumber) {
            int detector = portNumber / 16;
            this.setFeedbackPortConfidence(portNumber, (invalid >> detector & 1) != 0, (freeze >> detector & 1) != 0, (noSignal >> detector & 1) != 0, nodeChangePublisher);
        }
        publisher.accept("feedbackPortGroupConfidence", oldValue, this.feedbackConfidenceStatus);
    }

    public FeedbackConfidenceStatus getFeedbackPortGroupConfidence() {
        return this.feedbackConfidenceStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeedbackPortConfidence(int portNumber, boolean invalid, boolean freeze, boolean noSignal, NodeChangePublisher nodeChangePublisher) {
        FeedbackPort port = null;
        FeedbackConfidenceData oldValue = null;
        FeedbackConfidenceData confidence = null;
        List list = this.ports;
        synchronized (list) {
            FeedbackPort feedbackPort = (FeedbackPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
            if (feedbackPort != null) {
                oldValue = feedbackPort.getConfidence();
                confidence = new FeedbackConfidenceData(invalid, freeze, noSignal);
                feedbackPort.setConfidence(confidence);
                port = feedbackPort;
            } else {
                LOGGER.warn("No feedback port available for portNumber: {}", (Object)portNumber);
            }
        }
        if (port != null) {
            FeedbackPort feedbackPort = port;
            FeedbackConfidenceData feedbackOldValue = oldValue;
            FeedbackConfidenceData feedbackConfidence = confidence;
            LOGGER.debug("Publish confidence change, port: {}, oldValue: {}, newValue: {}", new Object[]{feedbackPort, feedbackOldValue, feedbackConfidence});
            nodeChangePublisher.firePortIndexedPropertyChange((Port)feedbackPort, "feedbackPortConfidence", feedbackPort.getId(), (Object)feedbackOldValue, (Object)feedbackConfidence);
        }
        if (port != null) {
            this.getPublisher().getSubjectPortEvents().onNext((Object)new FeedbackPortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeedbackPortSpeed(int portNumber, int address, int speed, NodeChangePublisher nodeChangePublisher) {
        LOGGER.debug("Set the feedback port speed, portNumber: {}, address: {}, speed: {}", new Object[]{portNumber, address, speed});
        FeedbackPort port = null;
        FeedbackPort globalPort = null;
        LinkedList<FeedbackAddressData> addresses = new LinkedList<FeedbackAddressData>();
        List list = this.ports;
        synchronized (list) {
            FeedbackPort feedbackPort = (FeedbackPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
            if (feedbackPort != null) {
                if (CollectionUtils.isNotEmpty((Collection)feedbackPort.getAddresses())) {
                    addresses.addAll(feedbackPort.getAddresses());
                    for (FeedbackAddressData addressData : addresses) {
                        if (address != addressData.getAddress()) continue;
                        addressData.setSpeed(speed);
                        feedbackPort.setAddresses(addresses);
                        port = feedbackPort;
                        break;
                    }
                }
            } else if (this.node.isGlobalDetectorAvailable()) {
                LOGGER.info("Feedback speed event for global detector number: {}, address: {}, speed: {}", new Object[]{portNumber, address, speed});
                if (CollectionUtils.isNotEmpty((Collection)this.globalDetectorPort.getAddresses())) {
                    addresses.addAll(this.globalDetectorPort.getAddresses());
                    boolean found = false;
                    for (FeedbackAddressData addressData : addresses) {
                        if (address != addressData.getAddress()) continue;
                        addressData.setSpeed(speed);
                        found = true;
                        break;
                    }
                    if (!found) {
                        FeedbackAddressData addressData = new FeedbackAddressData(address, EnrailmentDirectionEnum.LOCOMOTIVE_RIGHT);
                        addressData.setSpeed(speed);
                        addresses.add(addressData);
                        LOGGER.info("Processing global speed event, prepared addresses: {}", addresses);
                    }
                } else {
                    FeedbackAddressData addressData = new FeedbackAddressData(address, EnrailmentDirectionEnum.LOCOMOTIVE_RIGHT);
                    addressData.setSpeed(speed);
                    LOGGER.info("Create new addressData: {}", (Object)addressData);
                    addresses.add(addressData);
                }
                this.globalDetectorPort.setAddresses(addresses);
                globalPort = this.globalDetectorPort;
            } else {
                LOGGER.warn("No feedback port available for portNumber: {}", (Object)portNumber);
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortIndexedPropertyChange(port, "feedbackPortAddresses", port.getId(), null, addresses);
            this.getPublisher().getSubjectPortEvents().onNext((Object)new FeedbackPortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
        if (globalPort != null) {
            nodeChangePublisher.firePortIndexedPropertyChange(globalPort, "globalDetectorFeedbackPort", globalPort.getId(), null, addresses);
            this.getPublisher().getSubjectPortEvents().onNext((Object)new FeedbackPortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), globalPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeedbackPortDynStates(int portNumber, List<FeedbackDynStateData> dynStates, NodeChangePublisher nodeChangePublisher) {
        FeedbackPort port = null;
        List list = this.ports;
        synchronized (list) {
            FeedbackPort feedbackPort = (FeedbackPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
            if (feedbackPort != null) {
                feedbackPort.addDynStates(dynStates);
                port = feedbackPort;
            } else if (this.node.isGlobalDetectorAvailable()) {
                LOGGER.info("Feedback dynstate event for global detector number: {}, dynStates: {}", (Object)portNumber, dynStates);
                this.globalDetectorPort.addDynStates(dynStates);
                port = this.globalDetectorPort;
            } else {
                LOGGER.warn("No feedback port available for portNumber: {}", (Object)portNumber);
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortIndexedPropertyChange((Port)port, "feedbackPortDynStates", port.getId(), null, (Object)port.getDynStates());
            this.getPublisher().getSubjectPortEvents().onNext((Object)new FeedbackPortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }
}

