/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.jbidibc.messages.enums.PortConfigStatus;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortStatusEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPortHandler
extends AbstractPortHandler<InputPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortHandler.class);

    public InputPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<InputPort> inputPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the input ports on the node: {}", inputPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(inputPorts)) {
                this.ports.addAll(inputPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.inputPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(InputPort.class);
        ConnectionNodeAwarePublisher publisher = this.getPublisher();
        publisher.getSubjectPortEvents().onNext((Object)new PortListEvent(publisher.getConnectionId(), publisher.getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.info("Prepare the input ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsInputPort()) {
                LOGGER.trace("The current port supports input port: {}", (Object)genericPort);
                InputPort inputPort = new InputPort(genericPort);
                inputPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(inputPort);
                continue;
            }
            LOGGER.trace("The current port does not support input port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.inputPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<InputPort> enabledPorts = new LinkedList<InputPort>();
            for (InputPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortStatus(int portNumber, int portState, NodeChangePublisher nodeChangePublisher) {
        InputPort port = null;
        boolean portConfigChanged = false;
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                GenericPort genericPort = PortListUtils.findGenericPortByPortNumber((List)this.node.getGenericPorts(), (int)portNumber);
                if (genericPort != null && genericPort.isSupportsInputPort()) {
                    LOGGER.info("The current port supports input port: {}", (Object)genericPort);
                    genericPort.setPortStatus(ByteUtils.getLowByte((int)portState));
                    if (genericPort.isInactive()) {
                        genericPort.setInactive(false);
                        portConfigChanged = true;
                    }
                    port = new InputPort(genericPort);
                } else {
                    LOGGER.info("No generic port found or the current generic port does not support input port, port number: {}, port: {}", (Object)portNumber, (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    InputPort inputPort = (InputPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (inputPort != null) {
                        try {
                            InputPortEnum type = InputPortEnum.valueOf((byte)ByteUtils.getLowByte((int)portState));
                            InputPortStatus status = InputPortStatus.valueOf((InputPortEnum)type);
                            LOGGER.info("InputPort status has changed, port: {}, status: {}", (Object)inputPort, (Object)status);
                            inputPort.setStatus((BidibStatus)status);
                            if (inputPort.isInactive()) {
                                inputPort.setInactive(false);
                                portConfigChanged = true;
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.warn("Set the port status failed, port: {}, portState: {}, message: {}", new Object[]{inputPort, portState, ex.getMessage()});
                            inputPort.setPortConfigErrorCode(Integer.valueOf(ByteUtils.getInt((byte)1)));
                            inputPort.setConfigStatus(PortConfigStatus.CONFIG_ERROR);
                            portConfigChanged = true;
                        }
                        port = inputPort;
                    } else {
                        LOGGER.warn("No input port available for portNumber: {}", (Object)portNumber);
                    }
                } else {
                    LOGGER.debug("No input ports or generic ports available.");
                }
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortStatusChanged(InputPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            this.getPublisher().getSubjectPortEvents().onNext((Object)new PortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }
}

