/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortStatusEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightPortHandler
extends AbstractPortHandler<LightPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPortHandler.class);

    public LightPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<LightPort> lightPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the light ports on the node: {}", lightPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(lightPorts)) {
                this.ports.addAll(lightPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.lightPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(LightPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.info("Prepare the light ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsLightPort()) {
                LOGGER.trace("The current port supports light port: {}", (Object)genericPort);
                LightPort lightPort = new LightPort(genericPort);
                lightPort.setId(genericPort.getPortNumber().intValue());
                LOGGER.trace("Cache the light port: {}", (Object)lightPort);
                this.ports.add(lightPort);
                continue;
            }
            LOGGER.trace("The current port does not support light port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.lightPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LightPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<LightPort> enabledPorts = new LinkedList<LightPort>();
            for (LightPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortStatus(int portNumber, int portState, NodeChangePublisher nodeChangePublisher) {
        LightPort port = null;
        boolean portConfigChanged = false;
        LOGGER.debug("Set the light port status, port number: {}, portState: {}", (Object)portNumber, (Object)portState);
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                for (GenericPort genericPort : this.node.getGenericPorts()) {
                    if (genericPort.isSupportsLightPort() && genericPort.getPortNumber() == portNumber) {
                        LOGGER.debug("The current port supports light port: {}", (Object)genericPort);
                        genericPort.setPortStatus(ByteUtils.getLowByte((int)portState));
                        if (genericPort.isInactive()) {
                            genericPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = new LightPort(genericPort);
                        break;
                    }
                    LOGGER.trace("The current port does not support light port: {}", (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    LOGGER.debug("Update the port status in the light ports.");
                    LightPort lightPort = (LightPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (lightPort != null) {
                        LightPortEnum type = LightPortEnum.valueOf((byte)ByteUtils.getLowByte((int)portState));
                        LightPortStatus status = LightPortStatus.valueOf((LightPortEnum)type);
                        LOGGER.trace("LightPort status has changed, port: {}, status: {}", (Object)lightPort, (Object)status);
                        lightPort.setStatus((BidibStatus)status);
                        if (lightPort.isInactive()) {
                            lightPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = lightPort;
                    } else {
                        LOGGER.warn("No light port available for portNumber: {}", (Object)portNumber);
                    }
                } else {
                    LOGGER.debug("No light ports or generic ports available.");
                }
            }
        }
        if (port != null) {
            LOGGER.debug("The status of the light port has changed: {}", port);
            nodeChangePublisher.firePortStatusChanged(LightPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            PortStatusEvent portStatusEvent = new PortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port);
            LOGGER.debug("Publish the port status event: {}", (Object)portStatusEvent);
            this.getPublisher().getSubjectPortEvents().onNext((Object)portStatusEvent);
        }
    }
}

