/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortStatusEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorPortHandler
extends AbstractPortHandler<MotorPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPortHandler.class);

    public MotorPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<MotorPort> motorPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the motor ports on the node: {}", motorPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(motorPorts)) {
                this.ports.addAll(motorPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.motorPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(MotorPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.debug("Prepare the motor ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsMotorPort()) {
                LOGGER.trace("The current port supports motor port: {}", (Object)genericPort);
                MotorPort motorPort = new MotorPort(genericPort);
                motorPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(motorPort);
                continue;
            }
            LOGGER.trace("The current port does not support motor port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.motorPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MotorPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<MotorPort> enabledPorts = new LinkedList<MotorPort>();
            for (MotorPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortValue(int portNumber, int portValue, NodeChangePublisher nodeChangePublisher) {
        MotorPort port = null;
        boolean portConfigChanged = false;
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                GenericPort genericPort = PortListUtils.findGenericPortByPortNumber((List)this.node.getGenericPorts(), (int)portNumber);
                if (genericPort != null && genericPort.isSupportsMotorPort()) {
                    LOGGER.info("The current port supports motor port: {}", (Object)genericPort);
                    genericPort.setPortValue(Integer.valueOf(portValue));
                    if (genericPort.isInactive()) {
                        genericPort.setInactive(false);
                        portConfigChanged = true;
                    }
                    port = new MotorPort(genericPort);
                } else {
                    LOGGER.info("No generic port found or the current generic port does not support motor port, port number: {}, port: {}", (Object)portNumber, (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    MotorPort motorPort = (MotorPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (motorPort != null) {
                        Integer oldValue = motorPort.getValue();
                        if (oldValue == null || oldValue != portValue) {
                            motorPort.setValue(Integer.valueOf(portValue));
                            LOGGER.debug("MotorPort value has changed, port: {}, value: {}", (Object)motorPort, (Object)portValue);
                            if (motorPort.isInactive()) {
                                motorPort.setInactive(false);
                                portConfigChanged = true;
                            }
                            port = motorPort;
                        }
                    } else {
                        LOGGER.warn("No motor port available for portNumber: {}", (Object)portNumber);
                    }
                } else {
                    LOGGER.warn("No motor ports or generic ports available.");
                }
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortValueChanged(MotorPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            this.getPublisher().getSubjectPortEvents().onNext((Object)new PortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }
}

