/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvData;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.FeedbackDynStateData;
import org.bidib.jbidibc.messages.FeedbackPosition;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortType;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.PortMapUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.InterfaceNodeInterface;
import org.bidib.wizard.api.model.LabelAware;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.OccupancyNodeInterface;
import org.bidib.wizard.api.model.PortsProvider;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.event.NodeStatusEvent;
import org.bidib.wizard.api.model.firmware.FirmwareVersion;
import org.bidib.wizard.api.model.listener.AccessoryListListener;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.FlagListListener;
import org.bidib.wizard.api.model.listener.MacroListListener;
import org.bidib.wizard.api.model.listener.NodeListener;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.AnalogPortHandler;
import org.bidib.wizard.common.node.BacklightPortHandler;
import org.bidib.wizard.common.node.BoosterNode;
import org.bidib.wizard.common.node.CommandStationNode;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.common.node.FeedbackPortHandler;
import org.bidib.wizard.common.node.InputPortHandler;
import org.bidib.wizard.common.node.InterfaceNode;
import org.bidib.wizard.common.node.LightPortHandler;
import org.bidib.wizard.common.node.MotorPortHandler;
import org.bidib.wizard.common.node.OccupancyNode;
import org.bidib.wizard.common.node.PortConfigHandler;
import org.bidib.wizard.common.node.PortsChangeWrapper;
import org.bidib.wizard.common.node.ServoPortHandler;
import org.bidib.wizard.common.node.SoundPortHandler;
import org.bidib.wizard.common.node.SwitchPairPortHandler;
import org.bidib.wizard.common.node.SwitchPortHandler;
import org.bidib.wizard.common.node.SwitchingNode;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.FeedbackConfidenceStatus;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.model.stringdata.StoredStrings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
extends Model
implements NodeInterface,
LabelAware,
NodeChangePublisher,
PortsProvider {
    private static final long serialVersionUID = 1L;
    protected final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<NodeListener> listeners = new LinkedList<NodeListener>();
    private List<MacroListListener> macroListListeners = new LinkedList<MacroListListener>();
    private List<AccessoryListListener> accessoryListListeners = new LinkedList<AccessoryListListener>();
    private List<CvDefinitionListener> cvDefinitionListeners = new LinkedList<CvDefinitionListener>();
    private List<FlagListListener> flagListListeners = new LinkedList<FlagListListener>();
    private Boolean addressMessagesEnabled;
    private Boolean dccStartEnabled;
    private Boolean externalStartEnabled;
    private Boolean feedbackMessagesEnabled;
    private Boolean feedbackMirrorDisabled;
    private IdentifyState identifyState;
    private DetachedState detachedState = DetachedState.ATTACHED;
    private SysErrorEnum sysError;
    private String reasonData;
    private Boolean keyMessagesEnabled;
    private String label;
    private final org.bidib.jbidibc.messages.Node node;
    private final PropertyChangeListener pclNode;
    private final PropertyChangeListener pclBoosterNode;
    private int storableMacroCount;
    private int maxMacroSteps;
    private int maxAspectsCount;
    private boolean globalDetectorAvailable;
    private int baseNumber;
    private boolean updatable;
    private FirmwareVersion updateFirmwareVersion;
    private boolean bootloaderNode;
    private boolean nodeHasError;
    private VendorCvData vendorCV;
    private Object configVarsLock = new Object();
    private Object genericPortsLock = new Object();
    private final Map<String, ConfigurationVariable> configVariables;
    private List<Flag> flags = new LinkedList<Flag>();
    private PortConfigHandler genericPortConfigHandler;
    private AnalogPortHandler analogPortHandler;
    private BacklightPortHandler backlightPortHandler;
    private FeedbackPortHandler feedbackPortHandler;
    private InputPortHandler inputPortHandler;
    private LightPortHandler lightPortHandler;
    private MotorPortHandler motorPortHandler;
    private ServoPortHandler servoPortHandler;
    private SoundPortHandler soundPortHandler;
    private SwitchPortHandler switchPortHandler;
    private SwitchPairPortHandler switchPairPortHandler;
    private List<Macro> macros = new LinkedList<Macro>();
    private List<Accessory> accessories = new LinkedList<Accessory>();
    private Map<Class<?>, List<PortListListener>> portListListeners = new LinkedHashMap();
    private Map<Class<?>, List<PortListener<? extends Port<? extends BidibStatus>>>> portListeners = new LinkedHashMap();
    private Map<Class<?>, List<PortListener<? extends Port<? extends BidibStatus>>>> portValueListeners = new LinkedHashMap();
    private PropertyChangeListener macroPendingChangesListener;
    private PropertyChangeListener accessoryPendingChangesListener;
    private CommandStationNodeInterface commandStationNodeProxy;
    private BoosterNodeInterface boosterNodeProxy;
    private InterfaceNodeInterface interfaceNodeProxy;
    private SwitchingNodeInterface switchingNodeProxy;
    private OccupancyNodeInterface occupancyNodeProxy;
    private NodeStatusEvent.StatusIdentifier nodeLoadStatus = NodeStatusEvent.StatusIdentifier.InitialLoadPending;
    private final Object initialLoadFinishedLock = new Object();
    private ConnectionNodeAwarePublisher publisher;
    private WizardLabelWrapper wizardLabelWrapper;
    private StoredStrings storedStringsNs2;

    public Node(final org.bidib.jbidibc.messages.Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The node must not be null!");
        }
        this.node = node;
        this.configVariables = new LinkedHashMap<String, ConfigurationVariable>();
        this.pclNode = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "userName": {
                        Node.this.LOGGER.info("The username of the node has changed: {}, oldvalue: '{}', newvalue: '{}'", new Object[]{node.getStoredString(1), evt.getOldValue(), evt.getNewValue()});
                        break;
                    }
                }
                Node.this.firePropertyChange(new PropertyChangeEvent((Object)Node.this, "node." + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
            }
        };
        this.node.addPropertyChangeListener(this.pclNode);
        this.pclBoosterNode = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node.this.firePropertyChange(new PropertyChangeEvent((Object)Node.this, "boosterNode." + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
            }
        };
    }

    public void setEventPublisher(ConnectionNodeAwarePublisher publisher) {
        this.publisher = publisher;
    }

    public void setWizardLabelWrapper(WizardLabelWrapper wizardLabelWrapper) {
        this.wizardLabelWrapper = wizardLabelWrapper;
    }

    public void initialize() {
        if (NodeUtils.hasCommandStationFunctions((long)this.node.getUniqueId())) {
            this.LOGGER.info("The node has command station functions.");
            this.commandStationNodeProxy = new CommandStationNode(this, this.publisher);
            this.LOGGER.debug("Created new instance of CommandStationNode: {}", (Object)this.commandStationNodeProxy);
        }
        if (NodeUtils.hasBoosterFunctions((long)this.node.getUniqueId())) {
            this.LOGGER.info("The node has booster functions.");
            this.boosterNodeProxy = new BoosterNode(this, this.publisher);
            ((BoosterNode)this.boosterNodeProxy).addPropertyChangeListener(this.pclBoosterNode);
        }
        if (NodeUtils.hasSubNodesFunctions((long)this.node.getUniqueId())) {
            this.LOGGER.info("The node has subnodes functions.");
            this.interfaceNodeProxy = new InterfaceNode(this);
        }
        if (NodeUtils.hasSwitchFunctions((long)this.node.getUniqueId()) || NodeUtils.hasAccessoryFunctions((long)this.node.getUniqueId())) {
            this.LOGGER.info("The node has switching functions.");
            this.switchingNodeProxy = new SwitchingNode(this);
        }
        if (NodeUtils.hasFeedbackFunctions((long)this.node.getUniqueId())) {
            this.LOGGER.info("The node has occupancy functions.");
            this.occupancyNodeProxy = new OccupancyNode(this);
        }
        this.genericPortConfigHandler = new PortConfigHandler(this, this.publisher);
        this.analogPortHandler = new AnalogPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.backlightPortHandler = new BacklightPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.feedbackPortHandler = new FeedbackPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.inputPortHandler = new InputPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.lightPortHandler = new LightPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.motorPortHandler = new MotorPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.servoPortHandler = new ServoPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.soundPortHandler = new SoundPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.switchPortHandler = new SwitchPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.switchPairPortHandler = new SwitchPairPortHandler(this, this.publisher, this.wizardLabelWrapper);
        this.macroPendingChangesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node.this.LOGGER.info("The pending changes flag of a macro has been changed.");
                Node.this.fireMacroPendingChangesChanged();
            }
        };
        this.accessoryPendingChangesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node.this.LOGGER.trace("The property of an accessory has been changed.");
                switch (evt.getPropertyName()) {
                    case "pendingChanges": {
                        Node.this.fireAccessoryPendingChangesChanged();
                        break;
                    }
                    case "totalAspectsOfAccessory": {
                        Integer accessoryId = evt.getNewValue() != null ? (Integer)evt.getNewValue() : null;
                        Node.this.LOGGER.info("The total aspects of an accessory have been changed, accessory id: {}", (Object)accessoryId);
                        Node.this.fireAccessoryChanged(accessoryId);
                        break;
                    }
                    case "accessoryExecutionState": {
                        Node.this.fireAccessoryExecutionStateChanged();
                        break;
                    }
                }
            }
        };
    }

    public void postLoadNodeDataProcessing() {
        if (this.node.isPortFlatModelAvailable()) {
            this.LOGGER.info("Set the GPIO port identifiers. Current node: {}", (Object)this);
            String switchPortIdentifier = null;
            if (ProductUtils.isOneControl((long)this.getUniqueId())) {
                switchPortIdentifier = "POWER";
            } else if (ProductUtils.isOneDriveTurn((long)this.getUniqueId())) {
                switchPortIdentifier = "MOTOR";
            }
            int gpioId = 0;
            for (InputPort inputPort : this.getInputPorts()) {
                inputPort.setPortIdentifier("GPIO " + gpioId++);
            }
            int switchPortId = 0;
            gpioId = 0;
            for (SwitchPort switchPort : this.getSwitchPorts()) {
                this.LOGGER.debug("Current switch port: {}", (Object)switchPort);
                if (!switchPort.isRemappingEnabled() || !PortMapUtils.supportsPortType((LcOutputType)LcOutputType.INPUTPORT, (Map)switchPort.getPortConfigX())) {
                    if (switchPortIdentifier != null) {
                        switchPort.setPortIdentifier(switchPortIdentifier + " " + switchPortId + "/" + (switchPortId + 1));
                    }
                    if (switchPort.isRemappingEnabled()) continue;
                    switchPortId += 2;
                    continue;
                }
                if (!switchPort.isRemappingEnabled()) continue;
                switchPort.setPortIdentifier("GPIO " + gpioId++);
            }
            switchPortId = 0;
            gpioId = 0;
            for (SwitchPairPort switchPairPort : this.getSwitchPairPorts()) {
                this.LOGGER.debug("Current switchPair port: {}", (Object)switchPairPort);
                if (!switchPairPort.isRemappingEnabled() || !PortMapUtils.supportsPortType((LcOutputType)LcOutputType.INPUTPORT, (Map)switchPairPort.getPortConfigX())) {
                    if (switchPortIdentifier != null) {
                        switchPairPort.setPortIdentifier(switchPortIdentifier + " " + switchPortId + "/" + (switchPortId + 1));
                    }
                    switchPortId += 2;
                    continue;
                }
                if (!switchPairPort.isRemappingEnabled()) continue;
                switchPairPort.setPortIdentifier("GPIO " + gpioId);
                gpioId += 2;
            }
        }
    }

    public void refreshNode() {
        this.LOGGER.info("Refresh the node.");
        this.firePortListChanged(AnalogPort.class);
        this.firePortListChanged(BacklightPort.class);
        this.firePortListChanged(InputPort.class);
        this.firePortListChanged(LightPort.class);
        this.firePortListChanged(MotorPort.class);
        this.firePortListChanged(ServoPort.class);
        this.firePortListChanged(SoundPort.class);
        this.firePortListChanged(SwitchPairPort.class);
        this.firePortListChanged(SwitchPort.class);
        this.fireMacroListChanged();
        this.fireAccessoryListChanged();
    }

    public byte[] getAddr() {
        return this.node.getAddr();
    }

    public long getUniqueId() {
        return this.node.getUniqueId();
    }

    public CommandStationNodeInterface getCommandStationNode() {
        return this.commandStationNodeProxy;
    }

    public BoosterNodeInterface getBoosterNode() {
        return this.boosterNodeProxy;
    }

    public InterfaceNodeInterface getInterfaceNode() {
        return this.interfaceNodeProxy;
    }

    public SwitchingNodeInterface getSwitchingNode() {
        return this.switchingNodeProxy;
    }

    public OccupancyNodeInterface getOccupancyNode() {
        return this.occupancyNodeProxy;
    }

    public void addNodeListener(NodeListener l) {
        this.listeners.add(l);
        this.addPropertyChangeListener((PropertyChangeListener)l);
    }

    public void removeNodeListener(NodeListener l) {
        this.listeners.remove(l);
        this.removePropertyChangeListener((PropertyChangeListener)l);
    }

    public void addPortListListener(Class<?> portClazz, PortListListener listener) {
        List<PortListListener> listeners = this.portListListeners.get(portClazz);
        if (listeners == null) {
            listeners = new LinkedList<PortListListener>();
            this.portListListeners.put(portClazz, listeners);
        }
        listeners.add(listener);
    }

    public void removePortListListener(Class<?> portClazz, PortListListener listener) {
        List<PortListListener> listeners = this.portListListeners.get(portClazz);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void addCvDefinitionListener(CvDefinitionListener listener) {
        if (!this.cvDefinitionListeners.contains(listener)) {
            this.cvDefinitionListeners.add(listener);
        } else {
            this.LOGGER.warn("The cvDefinitionListener is registered already: {}", (Object)listener);
        }
    }

    public void removeCvDefinitionListener(CvDefinitionListener listener) {
        this.cvDefinitionListeners.remove(listener);
    }

    public void firePortListChanged(Class<?> portClazz) {
        this.LOGGER.info("The port list has changed for class: {}", portClazz);
        List<PortListListener> listeners = this.portListListeners.get(portClazz);
        if (listeners != null) {
            this.notifyPortListListeners(listeners);
        }
    }

    private void notifyPortListListeners(Collection<PortListListener> listeners) {
        for (PortListListener l : listeners) {
            l.listChanged();
        }
    }

    public void addPortListener(Class<?> portClazz, PortListener<? extends Port<? extends BidibStatus>> listener) {
        List<PortListener<? extends Port<? extends BidibStatus>>> listeners = this.portListeners.get(portClazz);
        if (listeners == null) {
            listeners = new LinkedList<PortListener<? extends Port<? extends BidibStatus>>>();
            this.portListeners.put(portClazz, listeners);
        }
        if (listeners.contains(listener)) {
            this.LOGGER.warn("Listener is already registered: {}", listener);
        } else {
            listeners.add(listener);
        }
    }

    public void removePortListener(Class<?> portClazz, PortListener<? extends Port<? extends BidibStatus>> listener) {
        List<PortListener<? extends Port<? extends BidibStatus>>> listeners = this.portListeners.get(portClazz);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public <T extends BidibStatus> void firePortConfigChanged(Port<T> port) {
        Class<?> portClazz = port.getClass();
        this.LOGGER.debug("The port config has changed for port: {}", port);
        List<PortListener<?>> listeners = this.portListeners.get(portClazz);
        if (listeners != null) {
            this.notifyPortConfigListeners(listeners, port);
        } else {
            this.LOGGER.debug("No port config listeners available for portClazz: {}", portClazz);
        }
    }

    private <T extends BidibStatus> void notifyPortConfigListeners(List<PortListener<?>> listeners, Port<T> port) {
        PortsChangeWrapper.notifyPortConfigChanged(listeners, this, port);
    }

    public <T extends BidibStatus> void firePortStatusChanged(Class<? extends Port<T>> portClazz, Port<T> port) {
        SwitchingNodeInterface switchingNode;
        List<PortListener<?>> listeners = this.portListeners.get(portClazz);
        if (listeners != null) {
            this.notifyPortStatusListeners(listeners, port);
        } else {
            this.LOGGER.debug("No port status listeners available for portClazz: {}", portClazz);
        }
        if (NodeStatusEvent.StatusIdentifier.InitialLoadFinished != this.getNodeLoadStatusIdentifier() && (switchingNode = this.getSwitchingNode()) != null && !switchingNode.isPortQueryAllEnabled()) {
            AbstractPortHandler[] handlers = new AbstractPortHandler[]{this.lightPortHandler, this.inputPortHandler, this.switchPortHandler, this.switchPairPortHandler, this.servoPortHandler, this.backlightPortHandler, this.analogPortHandler, this.motorPortHandler, this.soundPortHandler};
            boolean pendingPortStatus = false;
            for (AbstractPortHandler handler : handlers) {
                pendingPortStatus = handler.hasPendingPortStatus();
                if (!pendingPortStatus) continue;
                this.LOGGER.debug("Found pending port status in handler: {}", (Object)handler);
                break;
            }
            if (!pendingPortStatus) {
                this.LOGGER.info("No pending port status found on node: {}", (Object)this);
                this.signalInitialLoadFinished();
            }
        }
    }

    private <T extends BidibStatus> void notifyPortStatusListeners(List<PortListener<?>> listeners, Port<T> port) {
        PortsChangeWrapper.notifyPortStatusChanged(listeners, this, port);
    }

    public void addPortValueListener(Class<?> portClazz, PortValueListener<?> listener) {
        List<PortListener<? extends Port<? extends BidibStatus>>> listeners = this.portValueListeners.get(portClazz);
        if (listeners == null) {
            listeners = new LinkedList<PortListener<? extends Port<? extends BidibStatus>>>();
            this.portValueListeners.put(portClazz, listeners);
        }
        listeners.add((PortListener<? extends Port<? extends BidibStatus>>)listener);
    }

    public void removePortValueListener(Class<?> portClazz, PortValueListener<?> listener) {
        List<PortListener<? extends Port<? extends BidibStatus>>> listeners = this.portValueListeners.get(portClazz);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void firePortValueChanged(Class<?> portClazz, Port<?> port) {
        this.LOGGER.info("The port value has changed for class: {}", portClazz);
        List<PortListener<?>> listeners = this.portValueListeners.get(portClazz);
        if (listeners != null) {
            this.notifyPortValueListeners(listeners, port);
        }
    }

    private void notifyPortValueListeners(Collection<PortListener<?>> listeners, Port<?> port) {
        PortsChangeWrapper.notifyPortValueChanged(listeners, this, port);
    }

    public void addMacroListListener(MacroListListener listener) {
        this.macroListListeners.add(listener);
    }

    public void removeMacroListListener(MacroListListener listener) {
        this.macroListListeners.remove(listener);
    }

    public void addAccessoryListListener(AccessoryListListener l) {
        this.accessoryListListeners.add(l);
    }

    public void removeAccessoryListListener(AccessoryListListener listener) {
        this.accessoryListListeners.remove(listener);
    }

    public void addFlagListListener(FlagListListener l) {
        this.flagListListeners.add(l);
    }

    public void removeFlagListListener(FlagListListener l) {
        this.flagListListeners.remove(l);
    }

    public Boolean isAddressMessagesEnabled() {
        return this.addressMessagesEnabled;
    }

    public void setAddressMessagesEnabled(Boolean addressMessagesEnabled) {
        Boolean oldValue = this.addressMessagesEnabled;
        this.addressMessagesEnabled = addressMessagesEnabled;
        this.fireAddressMessagesEnabledChanged(addressMessagesEnabled);
        this.firePropertyChange("addressMessagesEnabled", oldValue, addressMessagesEnabled);
    }

    public Boolean isDccStartEnabled() {
        return this.dccStartEnabled;
    }

    public void setDccStartEnabled(Boolean dccStartEnabled) {
        this.dccStartEnabled = dccStartEnabled;
        this.fireDccStartEnabledChanged(dccStartEnabled);
    }

    public Boolean isExternalStartEnabled() {
        return this.externalStartEnabled;
    }

    public void setExternalStartEnabled(Boolean externalStartEnabled) {
        this.externalStartEnabled = externalStartEnabled;
        this.fireExternalStartEnabledChanged(externalStartEnabled);
    }

    public Boolean isFeedbackMessagesEnabled() {
        return this.feedbackMessagesEnabled;
    }

    public void setFeedbackMessagesEnabled(Boolean feedbackMessagesEnabled) {
        this.feedbackMessagesEnabled = feedbackMessagesEnabled;
        this.fireFeedbackMessagesEnabledChanged(feedbackMessagesEnabled);
    }

    public Boolean isFeedbackMirrorDisabled() {
        return this.feedbackMirrorDisabled;
    }

    public void setFeedbackMirrorDisabled(Boolean feedbackMirrorDisabled) {
        this.LOGGER.info("Set the feedback mirror messages disabled: {}", (Object)feedbackMirrorDisabled);
        this.feedbackMirrorDisabled = feedbackMirrorDisabled;
        this.fireFeedbackMirrorDisabledChanged(feedbackMirrorDisabled);
    }

    public IdentifyState getIdentifyState() {
        return this.identifyState;
    }

    public void setIdentifyState(IdentifyState identifyState) {
        this.LOGGER.info("Set the identifyState: {}", (Object)identifyState);
        IdentifyState oldValue = this.identifyState;
        this.identifyState = identifyState;
        this.firePropertyChange("identifyState", oldValue, this.identifyState);
        this.fireIdentifyStateChanged(identifyState);
    }

    public void setDetachedState(DetachedState detachedState) {
        DetachedState oldValue = this.detachedState;
        this.detachedState = detachedState;
        this.node.setDetached(detachedState == DetachedState.DETACHED);
        this.firePropertyChange("detached", oldValue, this.detachedState);
        this.fireDetachedStateChanged(detachedState);
    }

    public DetachedState getDetachedState() {
        return this.detachedState;
    }

    public void setErrorState(SysErrorEnum sysError, String reasonData) {
        this.LOGGER.info("Set the error state: {}, reasonData: {}", (Object)sysError, (Object)reasonData);
        ErrorStatePropertyChange oldValue = new ErrorStatePropertyChange(this.sysError, this.reasonData);
        this.sysError = sysError;
        this.reasonData = reasonData;
        ErrorStatePropertyChange newValue = new ErrorStatePropertyChange(this.sysError, this.reasonData);
        this.firePropertyChange("errorState", oldValue, newValue);
    }

    public SysErrorEnum getErrorState() {
        return this.sysError;
    }

    public String getReasonData() {
        return this.reasonData;
    }

    public void setReasonData(String reasonData) {
        ErrorStatePropertyChange oldValue = new ErrorStatePropertyChange(this.sysError, this.reasonData);
        this.reasonData = reasonData;
        ErrorStatePropertyChange newValue = new ErrorStatePropertyChange(this.sysError, this.reasonData);
        this.LOGGER.info("New reason data was set.");
        this.firePropertyChange("reasonData", oldValue, newValue);
    }

    public boolean isNodeHasRestartPendingError() {
        return SysErrorEnum.BIDIB_ERR_RESET_REQUIRED.equals((Object)this.sysError);
    }

    public Boolean isKeyMessagesEnabled() {
        return this.keyMessagesEnabled;
    }

    public void setInputMessagesEnabled(Boolean keyMessagesEnabled) {
        this.keyMessagesEnabled = keyMessagesEnabled;
        this.fireKeyMessagesEnabledChanged(keyMessagesEnabled);
    }

    public String getLabel() {
        if (this.node != null) {
            String userName = this.node.getStoredString(1);
            this.LOGGER.trace("Found userName: {}", (Object)userName);
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                return userName;
            }
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.LOGGER.info("Set the label: {}", (Object)label);
        String oldValue = this.label;
        this.label = label;
        this.firePropertyChange("label", oldValue, label);
        this.fireLabelsChanged();
    }

    public org.bidib.jbidibc.messages.Node getNode() {
        return this.node;
    }

    public int getStorableMacroCount() {
        return this.storableMacroCount;
    }

    public void setStorableMacroCount(int storableMacroCount) {
        this.storableMacroCount = storableMacroCount;
    }

    public int getMaxMacroSteps() {
        return this.maxMacroSteps;
    }

    public void setMaxMacroSteps(int maxMacroSteps) {
        this.maxMacroSteps = maxMacroSteps;
    }

    public List<GenericPort> getGenericPorts() {
        return this.genericPortConfigHandler.getGenericPorts();
    }

    public List<Port<?>> getPorts() {
        LinkedList ports = new LinkedList();
        ports.addAll(this.analogPortHandler.getPorts(this));
        ports.addAll(this.backlightPortHandler.getPorts(this));
        ports.addAll(this.inputPortHandler.getPorts(this));
        ports.addAll(this.lightPortHandler.getPorts(this));
        ports.addAll(this.motorPortHandler.getPorts(this));
        ports.addAll(this.servoPortHandler.getPorts(this));
        ports.addAll(this.soundPortHandler.getPorts(this));
        ports.addAll(this.switchPairPortHandler.getPorts(this));
        ports.addAll(this.switchPortHandler.getPorts(this));
        return ports;
    }

    public <T extends Port<?>> List<T> getPorts(PortType portType) {
        switch (portType) {
            case ANALOGPORT: {
                return this.analogPortHandler.getPorts(this);
            }
            case BACKLIGHTPORT: {
                return this.backlightPortHandler.getPorts(this);
            }
            case INPUTPORT: {
                return this.inputPortHandler.getPorts(this);
            }
            case LIGHTPORT: {
                return this.lightPortHandler.getPorts(this);
            }
            case MOTORPORT: {
                return this.motorPortHandler.getPorts(this);
            }
            case SERVOPORT: {
                return this.servoPortHandler.getPorts(this);
            }
            case SOUNDPORT: {
                return this.soundPortHandler.getPorts(this);
            }
            case SWITCHPORT: {
                return this.switchPortHandler.getPorts(this);
            }
            case SWITCHPAIRPORT: {
                return this.switchPairPortHandler.getPorts(this);
            }
        }
        throw new IllegalArgumentException("No ports of type '" + portType + "' is handled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenericPorts(List<GenericPort> genericPorts) {
        Object object = this.genericPortsLock;
        synchronized (object) {
            this.LOGGER.info("Set the generic ports on the node: {}", (Object)this);
            this.genericPortConfigHandler.setGenericPorts(genericPorts);
            this.clearPortCache();
        }
    }

    public boolean isGenericPortsSet() {
        return this.genericPortConfigHandler.isGenericPortsSet();
    }

    public void setPortConfig(LcOutputType portType, int portNumber, Map<Byte, PortConfigValue<?>> portConfig, PropertyChangeListener pcl) {
        if (this.node.isPortFlatModelAvailable()) {
            this.genericPortConfigHandler.setPortConfig(portNumber, portConfig, pcl, this);
        } else {
            this.LOGGER.info("Set port config for type-oriented port model, porttype: {}, portNumber: {}", (Object)portType, (Object)portNumber);
            switch (portType) {
                case ANALOGPORT: {
                    this.setAnalogPortConfig(portNumber, portConfig);
                    break;
                }
                case BACKLIGHTPORT: {
                    this.setBacklightPortConfig(portNumber, portConfig);
                    break;
                }
                case INPUTPORT: {
                    this.setInputPortConfig(portNumber, portConfig);
                    break;
                }
                case LIGHTPORT: {
                    this.setLightPortConfig(portNumber, portConfig);
                    break;
                }
                case MOTORPORT: {
                    this.setMotorPortConfig(portNumber, portConfig);
                    break;
                }
                case SERVOPORT: {
                    this.setServoPortConfig(portNumber, portConfig);
                    break;
                }
                case SOUNDPORT: {
                    this.setSoundPortConfig(portNumber, portConfig);
                    break;
                }
                case SWITCHPORT: {
                    this.setSwitchPortConfig(portNumber, portConfig);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPortCache() {
        this.LOGGER.info("Clear the port cache on node: {}", (Object)this);
        Object object = this.genericPortsLock;
        synchronized (object) {
            this.analogPortHandler.clearPorts(this);
            this.backlightPortHandler.clearPorts(this);
            this.feedbackPortHandler.clearPorts(this);
            this.inputPortHandler.clearPorts(this);
            this.lightPortHandler.clearPorts(this);
            this.motorPortHandler.clearPorts(this);
            this.servoPortHandler.clearPorts(this);
            this.soundPortHandler.clearPorts(this);
            this.switchPortHandler.clearPorts(this);
            this.switchPairPortHandler.clearPorts(this);
        }
    }

    public void setAnalogPorts(List<AnalogPort> analogPorts) {
        this.LOGGER.info("Set the analog ports on the node: {}", analogPorts);
        this.analogPortHandler.setPorts(analogPorts, (NodeChangePublisher)this);
    }

    public List<AnalogPort> getAnalogPorts() {
        return this.analogPortHandler.getPorts(this);
    }

    public boolean hasAnalogPorts() {
        this.LOGGER.debug("Check if analog ports are available.");
        return this.analogPortHandler.hasPorts();
    }

    public void setAnalogPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.analogPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public void setSwitchPorts(List<SwitchPort> switchPorts) {
        this.LOGGER.info("Set the switch ports on the node: {}", switchPorts);
        this.switchPortHandler.setPorts(switchPorts, (NodeChangePublisher)this);
    }

    public List<SwitchPort> getSwitchPorts() {
        return this.switchPortHandler.getPorts(this);
    }

    public List<SwitchPort> getEnabledSwitchPorts() {
        return this.switchPortHandler.getEnabledPorts();
    }

    public void setSwitchPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.switchPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasSwitchPorts() {
        this.LOGGER.debug("Check if switch ports are available.");
        return this.switchPortHandler.hasPorts();
    }

    public void setSwitchPortStatus(int portNumber, int portState) {
        this.switchPortHandler.setPortStatus(portNumber, portState, this);
    }

    public void setSwitchPairPorts(List<SwitchPairPort> switchPairPorts) {
        this.LOGGER.info("Set the switchPair ports on the node: {}", switchPairPorts);
        this.switchPairPortHandler.setPorts(switchPairPorts, (NodeChangePublisher)this);
    }

    public List<SwitchPairPort> getSwitchPairPorts() {
        return this.switchPairPortHandler.getPorts(this);
    }

    public List<SwitchPairPort> getEnabledSwitchPairPorts() {
        return this.switchPairPortHandler.getEnabledPorts();
    }

    public void setSwitchPairPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.switchPairPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasSwitchPairPorts() {
        this.LOGGER.debug("Check if switchPair ports are available.");
        return this.switchPairPortHandler.hasPorts();
    }

    public void setSwitchPairPortStatus(int portNumber, int portState) {
        this.switchPairPortHandler.setPortStatus(portNumber, portState, this);
    }

    public void setLightPorts(List<LightPort> lightPorts) {
        this.LOGGER.info("Set the light ports on the node: {}", lightPorts);
        this.lightPortHandler.setPorts(lightPorts, (NodeChangePublisher)this);
    }

    public List<LightPort> getLightPorts() {
        return this.lightPortHandler.getPorts(this);
    }

    public List<LightPort> getEnabledLightPorts() {
        return this.lightPortHandler.getEnabledPorts();
    }

    public void setLightPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.LOGGER.info("Set the lightport config for port: {}", (Object)portNumber);
        this.lightPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasLightPorts() {
        this.LOGGER.debug("Check if light ports are available.");
        return this.lightPortHandler.hasPorts();
    }

    public void setLightPortStatus(int portNumber, int portState) {
        this.lightPortHandler.setPortStatus(portNumber, portState, this);
    }

    public void setBacklightPorts(List<BacklightPort> backlightPorts) {
        this.LOGGER.info("Set the backlight ports on the node: {}", backlightPorts);
        this.backlightPortHandler.setPorts(backlightPorts, (NodeChangePublisher)this);
    }

    public List<BacklightPort> getBacklightPorts() {
        return this.backlightPortHandler.getPorts(this);
    }

    public void setBacklightPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.backlightPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasBacklightPorts() {
        this.LOGGER.debug("Check if backlight ports are available.");
        return this.backlightPortHandler.hasPorts();
    }

    public void setBacklightPortValue(int portNumber, int portValue) {
        this.backlightPortHandler.setPortValue(portNumber, portValue, this);
    }

    public void setInputPorts(List<InputPort> inputPorts) {
        this.LOGGER.info("Set the input ports on the node: {}", inputPorts);
        this.inputPortHandler.setPorts(inputPorts, (NodeChangePublisher)this);
    }

    public List<InputPort> getInputPorts() {
        return this.inputPortHandler.getPorts(this);
    }

    public List<InputPort> getEnabledInputPorts() {
        return this.inputPortHandler.getEnabledPorts();
    }

    public void setInputPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.inputPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasInputPorts() {
        this.LOGGER.debug("Check if input ports are available.");
        return this.inputPortHandler.hasPorts();
    }

    public void setInputPortStatus(int portNumber, int portState) {
        this.inputPortHandler.setPortStatus(portNumber, portState, this);
    }

    public void setServoPorts(List<ServoPort> servoPorts) {
        this.LOGGER.info("Set the servo ports on the node: {}", servoPorts);
        this.servoPortHandler.setPorts(servoPorts, (NodeChangePublisher)this);
    }

    public List<ServoPort> getServoPorts() {
        return this.servoPortHandler.getPorts(this);
    }

    public void setServoPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.servoPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasServoPorts() {
        this.LOGGER.debug("Check if servo ports are available.");
        return this.servoPortHandler.hasPorts();
    }

    public void setServoPortValue(int portNumber, int portValue) {
        this.servoPortHandler.setPortValue(portNumber, portValue, this);
    }

    public void setMotorPorts(List<MotorPort> motorPorts) {
        this.LOGGER.info("Set the motor ports on the node: {}", motorPorts);
        this.motorPortHandler.setPorts(motorPorts, (NodeChangePublisher)this);
    }

    public List<MotorPort> getMotorPorts() {
        return this.motorPortHandler.getPorts(this);
    }

    public void setMotorPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.motorPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasMotorPorts() {
        this.LOGGER.debug("Check if motor ports are available.");
        return this.motorPortHandler.hasPorts();
    }

    public void setMotorPortValue(int portNumber, int portValue) {
        this.motorPortHandler.setPortValue(portNumber, portValue, this);
    }

    public void setSoundPorts(List<SoundPort> soundPorts) {
        this.LOGGER.info("Set the sound ports on the node: {}", soundPorts);
        this.soundPortHandler.setPorts(soundPorts, (NodeChangePublisher)this);
    }

    public List<SoundPort> getSoundPorts() {
        return this.soundPortHandler.getPorts(this);
    }

    public void setSoundPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig) {
        this.soundPortHandler.setPortConfig(portNumber, portConfig, this);
    }

    public boolean hasSoundPorts() {
        this.LOGGER.debug("Check if sound ports are available.");
        return this.soundPortHandler.hasPorts();
    }

    public List<SoundPort> getEnabledSoundPorts() {
        return this.soundPortHandler.getEnabledPorts();
    }

    public void setSoundPortStatus(int portNumber, int portState) {
        this.soundPortHandler.setPortStatus(portNumber, portState, this);
    }

    public boolean isGlobalDetectorAvailable() {
        return this.globalDetectorAvailable;
    }

    public void setGlobalDetectorAvailable(boolean globalDetectorAvailable) {
        this.globalDetectorAvailable = globalDetectorAvailable;
    }

    public int getBaseNumber() {
        return this.baseNumber;
    }

    public void setBaseNumber(int baseNumber) {
        int oldValue = this.baseNumber;
        this.baseNumber = baseNumber;
        this.firePropertyChange("baseNumber", oldValue, this.baseNumber);
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public FirmwareVersion getUpdateFirmwareVersion() {
        return this.updateFirmwareVersion;
    }

    public void setUpdateFirmwareVersion(FirmwareVersion updateFirmwareVersion) {
        FirmwareVersion oldValue = this.updateFirmwareVersion;
        this.updateFirmwareVersion = updateFirmwareVersion;
        this.firePropertyChange("updateFirmwareVersion", oldValue, this.updateFirmwareVersion);
    }

    public boolean isBootloaderNode() {
        return this.bootloaderNode;
    }

    public void setBootloaderNode(boolean bootloaderNode) {
        this.bootloaderNode = bootloaderNode;
    }

    public boolean isNodeHasError() {
        return this.nodeHasError || this.sysError != null && !SysErrorEnum.BIDIB_ERR_NONE.equals((Object)this.sysError);
    }

    public boolean isNodeHasError(boolean ignoreSysError) {
        if (ignoreSysError) {
            return this.nodeHasError;
        }
        return this.isNodeHasError();
    }

    public boolean isNodeHasSysError() {
        return this.sysError != null && !SysErrorEnum.BIDIB_ERR_NONE.equals((Object)this.sysError);
    }

    public void setNodeHasError(boolean nodeHasError) {
        this.LOGGER.info("The node has an error: {}", (Object)nodeHasError);
        boolean oldValue = this.nodeHasError;
        this.nodeHasError = nodeHasError;
        if (!nodeHasError) {
            this.setErrorState(null, null);
        }
        this.firePropertyChange("nodeHasError", oldValue, this.nodeHasError);
    }

    public boolean isFlatPortModel() {
        return this.getNode().isPortFlatModelAvailable();
    }

    public VendorCvData getVendorCV() {
        return this.vendorCV;
    }

    public void setVendorCV(VendorCvData vendorCV) {
        this.LOGGER.debug("Set the vendorCV: {}", (Object)vendorCV);
        this.vendorCV = vendorCV;
    }

    public Map<String, ConfigurationVariable> getConfigVariables() {
        if (this.configVariables == null) {
            return Collections.emptyMap();
        }
        return this.configVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigVariables(List<ConfigurationVariable> configurationVariables) {
        LinkedList<String> changedNames = new LinkedList<String>();
        Object object = this.configVarsLock;
        synchronized (object) {
            this.LOGGER.info("Set the configuration variables. Clear the old configuration variables.");
            this.configVariables.clear();
            if (configurationVariables != null) {
                changedNames.addAll(configurationVariables.stream().map(cv -> cv.getName()).distinct().collect(Collectors.toList()));
                this.configVariables.putAll(configurationVariables.stream().distinct().collect(Collectors.toMap(cv -> cv.getName(), cv -> cv)));
            }
        }
        this.fireConfigurationVariablesChanged(false, changedNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigVariableValues(List<ConfigurationVariable> configurationVars, boolean read) {
        this.LOGGER.info("Write config variables to node, number of CVs: {}, read: {}", (Object)configurationVars.size(), (Object)read);
        LinkedList<String> changedNames = new LinkedList<String>();
        Object object = this.configVarsLock;
        synchronized (object) {
            for (ConfigurationVariable updatedCV : configurationVars) {
                changedNames.add(updatedCV.getName());
                ConfigurationVariable storedCV = this.configVariables.get(updatedCV.getName());
                if (storedCV != null) {
                    storedCV.setValue(updatedCV.getValue());
                    storedCV.setTimeout(updatedCV.isTimeout());
                    continue;
                }
                this.LOGGER.info("Add new CV because the updated CV was not found in the stored CV values: {}", (Object)updatedCV);
                this.configVariables.put(updatedCV.getName(), updatedCV);
            }
            this.LOGGER.info("Number of stored CV: {}", (Object)this.configVariables.size());
        }
        this.fireConfigurationVariablesChanged(read, changedNames);
    }

    private void fireConfigurationVariablesChanged(boolean read, List<String> changedNames) {
        this.notifyConfigurationVariableValueListeners(this.cvDefinitionListeners, read, changedNames);
    }

    private void notifyConfigurationVariableValueListeners(Collection<CvDefinitionListener> listeners, boolean read, List<String> changedNames) {
        for (CvDefinitionListener l : listeners) {
            l.cvDefinitionValuesChanged(read, changedNames);
        }
    }

    private void fireAddressMessagesEnabledChanged(Boolean isAddressMessagesEnabled) {
        for (NodeListener l : this.listeners) {
            l.addressMessagesEnabledChanged((NodeInterface)this, isAddressMessagesEnabled);
        }
    }

    private void fireDccStartEnabledChanged(Boolean isDccStartEnabled) {
        for (NodeListener l : this.listeners) {
            l.dccStartEnabledChanged((NodeInterface)this, isDccStartEnabled);
        }
    }

    private void fireExternalStartEnabledChanged(Boolean isExternalStartEnabled) {
        for (NodeListener l : this.listeners) {
            l.externalStartEnabledChanged((NodeInterface)this, isExternalStartEnabled);
        }
    }

    private void fireFeedbackMessagesEnabledChanged(Boolean isFeedbackMessagesEnabled) {
        for (NodeListener l : this.listeners) {
            l.feedbackMessagesEnabledChanged((NodeInterface)this, isFeedbackMessagesEnabled);
        }
    }

    private void fireFeedbackMirrorDisabledChanged(Boolean feedbackMirrorDisabled) {
        for (NodeListener l : this.listeners) {
            l.feedbackMirrorDisabledChanged((NodeInterface)this, feedbackMirrorDisabled);
        }
    }

    private void fireIdentifyStateChanged(IdentifyState identifyState) {
        for (NodeListener l : this.listeners) {
            l.identifyStateChanged((NodeInterface)this, identifyState);
        }
    }

    private void fireDetachedStateChanged(DetachedState detachedState) {
        for (NodeListener l : this.listeners) {
            l.detachedStateChanged((NodeInterface)this, detachedState);
        }
    }

    private void fireKeyMessagesEnabledChanged(Boolean isKeyMessagesEnabled) {
        for (NodeListener l : this.listeners) {
            l.keyMessagesEnabledChanged((NodeInterface)this, isKeyMessagesEnabled);
        }
    }

    private void fireLabelsChanged() {
        for (NodeListener l : this.listeners) {
            l.labelsChanged((NodeInterface)this);
        }
    }

    public boolean equals(Object other) {
        this.LOGGER.debug("equals, other: {}", other);
        if (other != null) {
            return ((Node)((Object)other)).getNode().equals((Object)this.node);
        }
        return false;
    }

    public int hashCode() {
        if (this.node != null) {
            return this.node.hashCode();
        }
        this.LOGGER.warn("No core node available!");
        return super.hashCode();
    }

    public String toString() {
        String result = this.getLabel();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return "[" + NodeUtils.formatAddress((byte[])this.getAddr()) + "] " + result;
        }
        result = ByteUtils.getUniqueIdAsString((long)this.node.getUniqueId());
        return "[" + NodeUtils.formatAddress((byte[])this.getAddr()) + "] " + result;
    }

    public String toNodeAddressAndUniqueString() {
        StringBuilder nodeData = new StringBuilder();
        nodeData.append("[").append(NodeUtils.formatAddress((byte[])this.getAddr())).append("], ");
        nodeData.append(ByteUtils.getUniqueIdAsString((long)this.node.getUniqueId()));
        String result = this.getLabel();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            nodeData.append(", ").append(result);
        }
        return nodeData.toString();
    }

    public FeedbackPort getGlobalDetectorFeedbackPort() {
        this.LOGGER.debug("Get the feedback ports.");
        return this.feedbackPortHandler.getGlobalDetectorFeedbackPort();
    }

    public List<FeedbackPort> getFeedbackPorts() {
        this.LOGGER.debug("Get the feedback ports.");
        return this.feedbackPortHandler.getPorts(this);
    }

    public void setFeedbackPorts(List<FeedbackPort> feedbackPorts) {
        this.LOGGER.info("Set the feedback ports: {}", feedbackPorts);
        this.feedbackPortHandler.setPorts(feedbackPorts, (NodeChangePublisher)this);
    }

    public boolean hasFeedbackPorts() {
        this.LOGGER.debug("Check if feedback ports are available.");
        return this.feedbackPortHandler.hasPorts();
    }

    public int getFeedbackPortCount() {
        if (this.getOccupancyNode() != null) {
            return this.getOccupancyNode().getFeedbackPortCount();
        }
        return 0;
    }

    public void setFeedbackPortStatus(int detectorNumber, FeedbackPortStatus status, Integer timestamp) {
        this.LOGGER.debug("feedback port status, detector number: {}, status: {}, timestamp: {}", new Object[]{detectorNumber, status, timestamp});
        this.feedbackPortHandler.setPortStatus(detectorNumber, status, timestamp, this);
    }

    public void setFeedbackPortAddresses(int detectorNumber, List<FeedbackAddressData> addresses) {
        this.LOGGER.debug("feedback port addresses, detector number: {}, addresses: {}", (Object)detectorNumber, addresses);
        this.feedbackPortHandler.setPortAddresses(detectorNumber, addresses, this);
    }

    public void setFeedbackPortGroupConfidence(FeedbackConfidenceStatus feedbackConfidenceStatus) {
        this.LOGGER.debug("feedback port confidence, feedbackConfidenceStatus: {}", (Object)feedbackConfidenceStatus);
        this.feedbackPortHandler.setFeedbackPortGroupConfidence(feedbackConfidenceStatus, this, (propertyName, oldValue, newValue) -> {
            this.LOGGER.info("Fire the property change for propertyName: {}, newValue: {}", (Object)propertyName, newValue);
            this.firePropertyChange(propertyName, oldValue, newValue);
        });
    }

    public FeedbackConfidenceStatus getFeedbackPortGroupConfidence() {
        return this.feedbackPortHandler.getFeedbackPortGroupConfidence();
    }

    public void setFeedbackPortConfidence(int portNumber, boolean invalid, boolean freeze, boolean noSignal) {
        this.LOGGER.debug("feedback port confidence, port number: {}, invalid: {}, freeze: {}, noSignal: {}", new Object[]{portNumber, invalid, freeze, noSignal});
        this.feedbackPortHandler.setFeedbackPortConfidence(portNumber, invalid, freeze, noSignal, this);
    }

    public void setFeedbackPortSpeed(int detectorNumber, int address, int speed) {
        this.LOGGER.debug("feedback port speed, detector number: {}, address: {}, speed: {}", new Object[]{detectorNumber, address, speed});
        this.feedbackPortHandler.setFeedbackPortSpeed(detectorNumber, address, speed, this);
    }

    public void setFeedbackPortDynStates(int detectorNumber, List<FeedbackDynStateData> dynStates) {
        this.feedbackPortHandler.setFeedbackPortDynStates(detectorNumber, dynStates, this);
    }

    public List<Flag> getFlags() {
        return Collections.unmodifiableList(this.flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlags(Collection<Flag> flags) {
        List<Flag> list = this.flags;
        synchronized (list) {
            this.flags.clear();
            if (flags != null) {
                this.flags.addAll(flags);
            }
        }
        this.fireFlagListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMacros(List<Macro> macros) {
        List<Macro> list = this.macros;
        synchronized (list) {
            for (Macro macro : this.macros) {
                macro.removePropertyChangeListener("pendingChanges", this.macroPendingChangesListener);
            }
            this.macros.clear();
            if (macros != null) {
                this.macros.addAll(macros);
                Collections.sort(this.macros, new Comparator<Macro>(){

                    @Override
                    public int compare(Macro o1, Macro o2) {
                        return o1.getId() - o2.getId();
                    }
                });
            }
            for (Macro macro : this.macros) {
                macro.addPropertyChangeListener("pendingChanges", this.macroPendingChangesListener);
            }
        }
        this.fireMacroListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Macro> getMacros() {
        List<Macro> list = this.macros;
        synchronized (list) {
            return Collections.unmodifiableList(this.macros);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMacros() {
        this.LOGGER.debug("Check if macros are available.");
        List<Macro> list = this.macros;
        synchronized (list) {
            return CollectionUtils.isNotEmpty(this.macros);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnloadedMacros() {
        List<Macro> list = this.macros;
        synchronized (list) {
            for (Macro macro : this.macros) {
                if (!MacroSaveState.NOT_LOADED_FROM_NODE.equals((Object)macro.getMacroSaveState())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Macro replaceMacro(Macro macro, boolean silent) {
        this.LOGGER.info("Replace the macro: {}", (Object)macro);
        Macro existingMacro = null;
        List<Macro> list = this.macros;
        synchronized (list) {
            existingMacro = this.macros.get(macro.getId());
            if (existingMacro != null) {
                if (existingMacro == macro) {
                    this.LOGGER.info("Skip update the same instance: {}", (Object)macro);
                } else {
                    existingMacro.clearFunctions();
                    existingMacro.clearStartConditions();
                    existingMacro.setFunctions(macro.getFunctions());
                    existingMacro.setStartConditions(macro.getStartConditions());
                    existingMacro.setCycles(macro.getCycles());
                    existingMacro.setSpeed(macro.getSpeed());
                    if (StringUtils.isNotBlank((CharSequence)macro.getLabel())) {
                        existingMacro.setLabel(macro.getLabel());
                    }
                }
            } else {
                this.LOGGER.warn("No existing macro found with id: {}", (Object)macro.getId());
            }
        }
        if (!silent) {
            this.fireMacroListChanged();
        }
        return existingMacro;
    }

    private void fireMacroListChanged() {
        this.LOGGER.info("The macro list has changed.");
        for (MacroListListener l : this.macroListListeners) {
            l.listChanged();
        }
    }

    private void fireMacroPendingChangesChanged() {
        for (MacroListListener l : this.macroListListeners) {
            l.pendingChangesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessories(List<Accessory> accessories) {
        LinkedList<Accessory> oldValue = null;
        List<Accessory> list = this.accessories;
        synchronized (list) {
            this.LOGGER.info("Set accessories: {}", accessories);
            for (Accessory accessory : this.accessories) {
                accessory.removePropertyChangeListener(this.accessoryPendingChangesListener);
            }
            oldValue = new LinkedList<Accessory>(this.accessories);
            this.accessories.clear();
            if (accessories != null) {
                this.accessories.addAll(accessories);
                Collections.sort(this.accessories, new Comparator<Accessory>(){

                    @Override
                    public int compare(Accessory o1, Accessory o2) {
                        return o1.getId() - o2.getId();
                    }
                });
            }
            for (Accessory accessory : this.accessories) {
                accessory.addPropertyChangeListener(this.accessoryPendingChangesListener);
            }
        }
        this.fireAccessoryListChanged();
        this.firePropertyChange("accessories", oldValue, accessories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Accessory> getAccessories() {
        List<Accessory> list = this.accessories;
        synchronized (list) {
            return Collections.unmodifiableList(this.accessories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccessories() {
        this.LOGGER.debug("Check if accessories are available.");
        List<Accessory> list = this.accessories;
        synchronized (list) {
            return CollectionUtils.isNotEmpty(this.accessories);
        }
    }

    public int getMaxAspects() {
        return this.maxAspectsCount;
    }

    public void setMaxAspects(int maxAspectsCount) {
        this.maxAspectsCount = maxAspectsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accessory replaceAccessory(Accessory accessory, boolean silent) {
        Accessory existingAccessory = null;
        List<Accessory> list = this.accessories;
        synchronized (list) {
            existingAccessory = this.accessories.get(accessory.getId());
            this.LOGGER.info("Found accessory to update: {}", (Object)existingAccessory);
            if (existingAccessory != null) {
                existingAccessory.setStartupState(accessory.getStartupState());
                existingAccessory.setSwitchTime(accessory.getSwitchTime());
                existingAccessory.setTimeBaseUnit(accessory.getTimeBaseUnit());
                existingAccessory.setAspects(accessory.getAspects());
                if (StringUtils.isNotBlank((CharSequence)accessory.getLabel())) {
                    existingAccessory.setLabel(accessory.getLabel());
                }
                Collections.sort(this.accessories, new Comparator<Accessory>(){

                    @Override
                    public int compare(Accessory o1, Accessory o2) {
                        return o1.getId() - o2.getId();
                    }
                });
            } else {
                this.LOGGER.warn("No existing accessory found with id: {}", (Object)accessory.getId());
            }
        }
        if (!silent) {
            this.fireAccessoryListChanged();
        }
        return existingAccessory;
    }

    private void fireAccessoryPendingChangesChanged() {
        for (AccessoryListListener l : this.accessoryListListeners) {
            l.pendingChangesChanged();
        }
    }

    private void fireAccessoryExecutionStateChanged() {
        for (AccessoryListListener l : this.accessoryListListeners) {
            l.pendingChangesChanged();
        }
    }

    private void fireAccessoryChanged(Integer accessoryId) {
        for (AccessoryListListener l : this.accessoryListListeners) {
            l.accessoryChanged(accessoryId);
        }
    }

    private void fireAccessoryListChanged() {
        for (AccessoryListListener l : this.accessoryListListeners) {
            l.listChanged();
        }
    }

    private void fireFlagListChanged() {
        this.notifyFlagListListeners(this.flagListListeners);
    }

    private void notifyFlagListListeners(Collection<FlagListListener> listeners) {
        for (FlagListListener l : listeners) {
            l.listChanged();
        }
    }

    public void setFeedbackPosition(int decoderAddress, PositionLocationEnum locationType, int locationAddress, byte[] extendedData) {
        FeedbackPosition feedbackPosition = new FeedbackPosition(decoderAddress, locationType, locationAddress, extendedData, System.currentTimeMillis());
        this.firePropertyChange("feedbackPositions", null, feedbackPosition);
    }

    public boolean isCvDefinitionAvailable() {
        return this.vendorCV != null;
    }

    public <T extends BidibStatus> void firePortIndexedPropertyChange(Port<T> port, String propertyName, int index, Object oldValue, Object newValue) {
        super.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalInitialLoadRegistered() {
        NodeStatusEvent.StatusIdentifier oldValue;
        Object object = this.initialLoadFinishedLock;
        synchronized (object) {
            oldValue = this.nodeLoadStatus;
            this.nodeLoadStatus = NodeStatusEvent.StatusIdentifier.InitialLoadRegistered;
        }
        this.LOGGER.info("The node load status is changed to registered, node: {}, address: {}, oldValue: {}", new Object[]{this, NodeUtils.formatAddress((byte[])this.getAddr()), oldValue});
        this.firePropertyChange("nodeLoadStatus", oldValue, NodeStatusEvent.StatusIdentifier.InitialLoadRegistered);
        NodeStatusEvent nse = new NodeStatusEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeUtils.formatAddress((byte[])this.getAddr()), NodeStatusEvent.StatusIdentifier.InitialLoadRegistered);
        this.LOGGER.info("Publish the nodeStatusEvent: {}", (Object)nse);
        this.publisher.getSubjectNodeEvents().onNext((Object)nse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalInitialLoadFinished() {
        NodeStatusEvent.StatusIdentifier oldValue;
        Object object = this.initialLoadFinishedLock;
        synchronized (object) {
            oldValue = this.nodeLoadStatus;
            this.nodeLoadStatus = NodeStatusEvent.StatusIdentifier.InitialLoadFinished;
            this.initialLoadFinishedLock.notifyAll();
        }
        this.LOGGER.info("The initial load has finished, node: {}, address: {}, oldValue: {}", new Object[]{this, NodeUtils.formatAddress((byte[])this.getAddr()), oldValue});
        this.firePropertyChange("nodeLoadStatus", oldValue, NodeStatusEvent.StatusIdentifier.InitialLoadFinished);
        NodeStatusEvent nse = new NodeStatusEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeUtils.formatAddress((byte[])this.getAddr()), NodeStatusEvent.StatusIdentifier.InitialLoadFinished);
        this.LOGGER.info("Publish the nodeStatusEvent: {}", (Object)nse);
        this.publisher.getSubjectNodeEvents().onNext((Object)nse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalInitialLoadPartiallyFinished() {
        NodeStatusEvent.StatusIdentifier oldValue;
        Object object = this.initialLoadFinishedLock;
        synchronized (object) {
            oldValue = this.nodeLoadStatus;
            this.nodeLoadStatus = NodeStatusEvent.StatusIdentifier.InitialLoadPartiallyFinished;
            this.initialLoadFinishedLock.notifyAll();
        }
        this.LOGGER.info("The initial load has partially finished, node: {}, address: {}, oldValue: {}", new Object[]{this, NodeUtils.formatAddress((byte[])this.getAddr()), oldValue});
        this.firePropertyChange("nodeLoadStatus", oldValue, NodeStatusEvent.StatusIdentifier.InitialLoadPartiallyFinished);
        NodeStatusEvent nse = new NodeStatusEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeUtils.formatAddress((byte[])this.getAddr()), NodeStatusEvent.StatusIdentifier.InitialLoadPartiallyFinished);
        this.LOGGER.info("Publish the nodeStatusEvent: {}", (Object)nse);
        this.publisher.getSubjectNodeEvents().onNext((Object)nse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalResetInitialLoadFinished() {
        NodeStatusEvent.StatusIdentifier oldValue;
        Object object = this.initialLoadFinishedLock;
        synchronized (object) {
            oldValue = this.nodeLoadStatus;
            this.nodeLoadStatus = NodeStatusEvent.StatusIdentifier.InitialLoadPending;
            this.initialLoadFinishedLock.notifyAll();
        }
        this.LOGGER.info("The initial load is reset, node: {}, oldValue: {}", (Object)this, (Object)oldValue);
        this.firePropertyChange("nodeLoadStatus", oldValue, NodeStatusEvent.StatusIdentifier.InitialLoadPending);
        NodeStatusEvent nse = new NodeStatusEvent(this.publisher.getConnectionId(), this.publisher.getUniqueId().longValue(), NodeUtils.formatAddress((byte[])this.getAddr()), NodeStatusEvent.StatusIdentifier.InitialLoadPending);
        this.LOGGER.info("Publish the nodeStatusEvent: {}", (Object)nse);
        this.publisher.getSubjectNodeEvents().onNext((Object)nse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatusEvent.StatusIdentifier getNodeLoadStatusIdentifier() {
        NodeStatusEvent.StatusIdentifier initialLoadFinished;
        Object object = this.initialLoadFinishedLock;
        synchronized (object) {
            initialLoadFinished = this.nodeLoadStatus;
        }
        this.LOGGER.debug("The current initialLoadFinished: {}, node: {}", (Object)initialLoadFinished, (Object)this.node);
        return initialLoadFinished;
    }

    public Object getInitialLoadFinishedLock() {
        return this.initialLoadFinishedLock;
    }

    public StoredStrings getStoredStringsNs2() {
        return this.storedStringsNs2;
    }

    public void setStoredStringsNs2(StoredStrings storedStringsNs2) {
        StoredStrings oldValue = this.getStoredStringsNs2();
        this.storedStringsNs2 = storedStringsNs2;
        this.firePropertyChange("storedStringsNs2", oldValue, this.storedStringsNs2);
    }

    public static final class ErrorStatePropertyChange {
        private final SysErrorEnum sysError;
        private final String reasonData;

        public ErrorStatePropertyChange(SysErrorEnum sysError, String reasonData) {
            this.sysError = sysError;
            this.reasonData = reasonData;
        }

        public SysErrorEnum getSysError() {
            return this.sysError;
        }

        public String getReasonData() {
            return this.reasonData;
        }
    }
}

