/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import com.jgoodies.binding.beans.Model;
import java.lang.ref.WeakReference;
import java.util.Collection;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.OccupancyNodeInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccupancyNode
extends Model
implements OccupancyNodeInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OccupancyNode.class);
    private final WeakReference<NodeInterface> parent;

    public OccupancyNode(NodeInterface parent) {
        this.parent = new WeakReference<NodeInterface>(parent);
    }

    public NodeInterface getNode() {
        return (NodeInterface)this.parent.get();
    }

    public int getFeedbackPortCount() {
        int feedbackPortCount = 0;
        try {
            Feature featureBmSize = Feature.findFeature((Collection)this.getNode().getNode().getFeatures(), (int)0);
            if (featureBmSize != null) {
                feedbackPortCount = featureBmSize.getValue();
            }
            LOGGER.info("Number of feedbackPorts: {}", (Object)feedbackPortCount);
        }
        catch (Exception ex) {
            LOGGER.warn("Get the number of feedback ports failed.", (Throwable)ex);
            throw new RuntimeException("Get the number of feedback ports failed.", ex);
        }
        return feedbackPortCount;
    }
}

