/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.ports.event.PortConfigEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortConfigHandler
implements PropertyChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortConfigHandler.class);
    private final ConnectionNodeAwarePublisher publisher;
    private List<GenericPort> genericPorts = new LinkedList<GenericPort>();
    private AtomicBoolean genericPortsSet = new AtomicBoolean();

    public PortConfigHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher) {
        this.publisher = publisher;
    }

    private ConnectionNodeAwarePublisher getPublisher() {
        return this.publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenericPorts(List<GenericPort> genericPorts) {
        List<GenericPort> list = this.genericPorts;
        synchronized (list) {
            LOGGER.info("Set the generic ports on the node: {}", (Object)this);
            for (GenericPort port : this.genericPorts) {
                port.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.genericPorts.clear();
            this.genericPorts.addAll(genericPorts);
            for (GenericPort port : this.genericPorts) {
                port.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.genericPortsSet.set(true);
        }
    }

    public boolean isGenericPortsSet() {
        return this.genericPortsSet.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericPort> getGenericPorts() {
        LOGGER.debug("Get the generic ports.");
        List<GenericPort> list = this.genericPorts;
        synchronized (list) {
            return Collections.unmodifiableList(this.genericPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortConfig(int portNumber, Map<Byte, PortConfigValue<?>> portConfig, PropertyChangeListener pcl, NodeChangePublisher nodeChangePublisher) {
        try {
            GenericPort port = null;
            List<GenericPort> list = this.genericPorts;
            synchronized (list) {
                LOGGER.info("Set the port config, portNumber: {}", (Object)portNumber);
                try {
                    port = PortListUtils.findGenericPortByPortNumber(this.genericPorts, (int)portNumber);
                    if (port != null) {
                        if (pcl != null) {
                            port.addPropertyChangeListener(pcl);
                        }
                        port.setPortConfigX(portConfig);
                    } else {
                        LOGGER.warn("No generic port available with portNumber: {}", (Object)portNumber);
                    }
                }
                finally {
                    if (port != null && pcl != null) {
                        port.removePropertyChangeListener(pcl);
                    }
                }
                if (port != null) {
                    if (port.getCurrentPortType() != null) {
                        BacklightPort portToPublish;
                        switch (port.getCurrentPortType()) {
                            case BACKLIGHTPORT: {
                                portToPublish = new BacklightPort(port);
                                break;
                            }
                            case INPUTPORT: {
                                portToPublish = new InputPort(port);
                                break;
                            }
                            case LIGHTPORT: {
                                portToPublish = new LightPort(port);
                                break;
                            }
                            case SERVOPORT: {
                                portToPublish = new ServoPort(port);
                                break;
                            }
                            case SWITCHPORT: {
                                portToPublish = new SwitchPort(port);
                                break;
                            }
                            case SWITCHPAIRPORT: {
                                portToPublish = new SwitchPairPort(port);
                                break;
                            }
                            default: {
                                LOGGER.warn("Unknown port type for port with portNumber: {}", (Object)portNumber);
                                portToPublish = null;
                            }
                        }
                        if (portToPublish != null) {
                            nodeChangePublisher.firePortConfigChanged((Port)portToPublish);
                        }
                        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortConfigEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), (PortTypeAware)port));
                    } else {
                        LOGGER.warn("No port type available for port: {}", (Object)port);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Set port config failed for portNumber: {}", (Object)portNumber, (Object)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOGGER.info("The property has been changed, name: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        switch (evt.getPropertyName()) {
            case "portConfigErrorCode": {
                break;
            }
            case "portConfigChanged": {
                break;
            }
            case "portTypeChanged": {
                break;
            }
        }
    }
}

