/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortStatusListener;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortsChangeWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortsChangeWrapper.class);

    public static <P extends Port<S>, S extends BidibStatus> void notifyPortConfigChanged(List<PortListener<?>> listeners, NodeInterface node, P port) {
        List<PortListener> safeListeners = Collections.checkedList(listeners, PortListener.class);
        for (PortListener l : safeListeners) {
            LOGGER.info("Notify changed port config to listener: {}", (Object)l);
            l.configChanged(node, port);
        }
    }

    public static <P extends Port<S>, S extends BidibStatus> void notifyPortStatusChanged(Collection<PortListener<?>> listeners, NodeInterface node, P port) {
        ArrayList<PortStatusListener> safeListeners = new ArrayList<PortStatusListener>();
        for (PortListener<?> listener : listeners) {
            if (!(listener instanceof PortStatusListener)) continue;
            safeListeners.add((PortStatusListener)listener);
        }
        LOGGER.info("notifyPortStatusChanged, port: {}, safeListeners: {}", port, safeListeners);
        for (PortStatusListener l : safeListeners) {
            LOGGER.info("Notify changed port status to listener: {}", (Object)l);
            l.statusChanged(node, port);
        }
    }

    public static <P extends Port<S>, S extends BidibStatus> void notifyPortValueChanged(Collection<PortListener<?>> listeners, NodeInterface node, P port) {
        ArrayList<PortValueListener> safeListeners = new ArrayList<PortValueListener>();
        for (PortListener<?> listener : listeners) {
            if (!(listener instanceof PortValueListener)) continue;
            safeListeners.add((PortValueListener)listener);
        }
        LOGGER.info("notifyPortValueChanged, port: {}, safeListeners: {}", port, safeListeners);
        for (PortValueListener l : safeListeners) {
            LOGGER.info("Notify port value listener: {}", (Object)l);
            l.valueChanged(node, port);
        }
    }
}

