/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortValueEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServoPortHandler
extends AbstractPortHandler<ServoPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServoPortHandler.class);

    public ServoPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<ServoPort> servoPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the servo ports on the node: {}", servoPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(servoPorts)) {
                this.ports.addAll(servoPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.servoPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(ServoPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.debug("Prepare the cached servo ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsServoPort()) {
                LOGGER.trace("The current port supports servo port: {}", (Object)genericPort);
                ServoPort servoPort = new ServoPort(genericPort);
                servoPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(servoPort);
                continue;
            }
            LOGGER.trace("The current port does not support servo port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.servoPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServoPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<ServoPort> enabledPorts = new LinkedList<ServoPort>();
            for (ServoPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortValue(int portNumber, int portValue, NodeChangePublisher nodeChangePublisher) {
        ServoPort port = null;
        boolean portConfigChanged = false;
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                GenericPort genericPort = PortListUtils.findGenericPortByPortNumber((List)this.node.getGenericPorts(), (int)portNumber);
                if (genericPort != null && genericPort.isSupportsServoPort()) {
                    LOGGER.info("The current port supports servo port: {}", (Object)genericPort);
                    genericPort.setPortValue(Integer.valueOf(portValue));
                    if (genericPort.isInactive()) {
                        genericPort.setInactive(false);
                        portConfigChanged = true;
                    }
                    port = new ServoPort(genericPort);
                } else {
                    LOGGER.info("No generic port found or the current generic port does not support servo port, port number: {}, port: {}", (Object)portNumber, (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    ServoPort servoPort = (ServoPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (servoPort != null) {
                        servoPort.setValue(Integer.valueOf(portValue));
                        LOGGER.info("ServoPort value has changed, port: {}, value: {}", (Object)servoPort, (Object)portValue);
                        if (servoPort.isInactive()) {
                            servoPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = servoPort;
                    } else {
                        LOGGER.warn("No servo port available for portNumber: {}", (Object)portNumber);
                    }
                } else {
                    LOGGER.warn("No servo ports or generic ports available.");
                }
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortValueChanged(ServoPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            this.getPublisher().getSubjectPortEvents().onNext((Object)new PortValueEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), (PortTypeAware)port, Integer.valueOf(portValue)));
        }
    }
}

