/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.SoundPortEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortStatusEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPortHandler
extends AbstractPortHandler<SoundPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortHandler.class);

    public SoundPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<SoundPort> soundPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the sound ports on the node: {}", soundPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(soundPorts)) {
                this.ports.addAll(soundPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.soundPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(SoundPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.debug("Prepare the sound ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsSoundPort()) {
                LOGGER.trace("The current port supports sound port: {}", (Object)genericPort);
                SoundPort soundPort = new SoundPort(genericPort);
                soundPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(soundPort);
                continue;
            }
            LOGGER.trace("The current port does not support sound port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.soundPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SoundPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<SoundPort> enabledPorts = new LinkedList<SoundPort>();
            for (SoundPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortStatus(int portNumber, int portState, NodeChangePublisher nodeChangePublisher) {
        SoundPort port = null;
        boolean portConfigChanged = false;
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                GenericPort genericPort = PortListUtils.findGenericPortByPortNumber((List)this.node.getGenericPorts(), (int)portNumber);
                if (genericPort != null && genericPort.isSupportsSoundPort()) {
                    LOGGER.info("The current port supports sound port: {}", (Object)genericPort);
                    genericPort.setPortStatus(ByteUtils.getLowByte((int)portState));
                    if (genericPort.isInactive()) {
                        genericPort.setInactive(false);
                        portConfigChanged = true;
                    }
                    port = new SoundPort(genericPort);
                } else {
                    LOGGER.info("No generic port found or the current generic port does not support sound port, port number: {}, port: {}", (Object)portNumber, (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    SoundPort soundPort = (SoundPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (soundPort != null) {
                        SoundPortEnum type = SoundPortEnum.valueOf((byte)ByteUtils.getLowByte((int)portState));
                        SoundPortStatus status = SoundPortStatus.valueOf((SoundPortEnum)type);
                        LOGGER.debug("SoundPort status has changed, port: {}, status: {}", (Object)soundPort, (Object)status);
                        soundPort.setStatus((BidibStatus)status);
                        if (soundPort.isInactive()) {
                            soundPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = soundPort;
                    } else {
                        LOGGER.warn("No sound port available for portNumber: {}", (Object)portNumber);
                    }
                } else {
                    LOGGER.warn("No sound ports or generic ports available.");
                }
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortStatusChanged(SoundPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            this.getPublisher().getSubjectPortEvents().onNext((Object)new PortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }
}

