/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortStatusEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPairPortHandler
extends AbstractPortHandler<SwitchPairPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPairPortHandler.class);

    public SwitchPairPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<SwitchPairPort> switchPairPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the switchPair ports on the node: {}", switchPairPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(switchPairPorts)) {
                this.ports.addAll(switchPairPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.switchPairPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(SwitchPairPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.debug("Prepare the switchPair ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsSwitchPairPort()) {
                LOGGER.trace("The current port supports switchPair port: {}", (Object)genericPort);
                SwitchPairPort switchPort = new SwitchPairPort(genericPort);
                switchPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(switchPort);
                continue;
            }
            LOGGER.trace("The current port does not support switchPair port: {}", (Object)genericPort);
        }
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.switchPairPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SwitchPairPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<SwitchPairPort> enabledPorts = new LinkedList<SwitchPairPort>();
            for (SwitchPairPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortStatus(int portNumber, int portState, NodeChangePublisher nodeChangePublisher) {
        SwitchPairPort port = null;
        boolean portConfigChanged = false;
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                for (GenericPort genericPort : this.node.getGenericPorts()) {
                    if (genericPort.isSupportsSwitchPairPort() && genericPort.getPortNumber() == portNumber) {
                        LOGGER.info("The current port supports switchPair port: {}", (Object)genericPort);
                        genericPort.setPortStatus(ByteUtils.getLowByte((int)portState));
                        if (genericPort.isInactive()) {
                            genericPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = new SwitchPairPort(genericPort);
                        break;
                    }
                    LOGGER.trace("The current port does not support switchPair port: {}", (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    SwitchPairPort switchPairPort = (SwitchPairPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (switchPairPort != null) {
                        SwitchPortEnum type = SwitchPortEnum.valueOf((byte)ByteUtils.getLowByte((int)portState));
                        SwitchPortStatus status = SwitchPortStatus.valueOf((SwitchPortEnum)type);
                        LOGGER.debug("SwitchPort status has changed, port: {}, status: {}", (Object)switchPairPort, (Object)status);
                        switchPairPort.setStatus((BidibStatus)status);
                        if (switchPairPort.isInactive()) {
                            switchPairPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = switchPairPort;
                    } else {
                        LOGGER.warn("No switchPair port available for portNumber: {}", (Object)portNumber);
                    }
                }
            } else {
                LOGGER.debug("No switchPair ports or generic ports available.");
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortStatusChanged(SwitchPairPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            this.getPublisher().getSubjectPortEvents().onNext((Object)new PortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }
}

