/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeChangePublisher;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.AbstractPortHandler;
import org.bidib.wizard.common.node.ConnectionNodeAwarePublisher;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.ports.event.PortListEvent;
import org.bidib.wizard.model.ports.event.PortStatusEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortHandler
extends AbstractPortHandler<SwitchPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortHandler.class);

    public SwitchPortHandler(NodeInterface node, ConnectionNodeAwarePublisher publisher, WizardLabelWrapper wizardLabelWrapper) {
        super(node, publisher, wizardLabelWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPorts(List<SwitchPort> switchPorts, NodeChangePublisher nodeChangePublisher) {
        LOGGER.info("Set the switch ports on the node: {}", switchPorts);
        List list = this.ports;
        synchronized (list) {
            this.ports.clear();
            if (CollectionUtils.isNotEmpty(switchPorts)) {
                this.ports.addAll(switchPorts);
                NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
                BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.switchPort, this.ports);
            }
            this.portsProcessed = false;
        }
        nodeChangePublisher.firePortListChanged(SwitchPort.class);
        this.getPublisher().getSubjectPortEvents().onNext((Object)new PortListEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), this.ports));
    }

    @Override
    protected void cachePorts(List<GenericPort> genericPorts) {
        LOGGER.info("Prepare the switch ports.");
        for (GenericPort genericPort : genericPorts) {
            if (genericPort.isSupportsSwitchPort()) {
                LOGGER.trace("The current port supports switch port: {}", (Object)genericPort);
                SwitchPort switchPort = new SwitchPort(genericPort);
                switchPort.setId(genericPort.getPortNumber().intValue());
                this.ports.add(switchPort);
                continue;
            }
            LOGGER.trace("The current port does not support switch port: {}", (Object)genericPort);
        }
        LOGGER.info("Prepared the switch ports: {}", (Object)this.ports);
        NodeLabels nodeLabels = this.getWizardLabelWrapper().getWizardLabelFactory().loadLabels(this.node.getUniqueId(), new String[0]);
        BidibLabelUtils.applyPortLabels(nodeLabels, WizardLabelFactory.LabelTypes.switchPort, this.ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SwitchPort> getEnabledPorts() {
        List list = this.ports;
        synchronized (list) {
            LinkedList<SwitchPort> enabledPorts = new LinkedList<SwitchPort>();
            for (SwitchPort port : this.ports) {
                if (!port.isEnabled()) continue;
                enabledPorts.add(port);
            }
            return Collections.unmodifiableList(enabledPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortStatus(int portNumber, int portState, NodeChangePublisher nodeChangePublisher) {
        SwitchPort port = null;
        boolean portConfigChanged = false;
        List list = this.ports;
        synchronized (list) {
            if (this.node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)this.node.getGenericPorts())) {
                for (GenericPort genericPort : this.node.getGenericPorts()) {
                    if (genericPort.isSupportsSwitchPort() && genericPort.getPortNumber() == portNumber) {
                        LOGGER.info("The current port supports switch port: {}", (Object)genericPort);
                        genericPort.setPortStatus(ByteUtils.getLowByte((int)portState));
                        if (genericPort.isInactive()) {
                            genericPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = new SwitchPort(genericPort);
                        break;
                    }
                    LOGGER.trace("The current port does not support switch port: {}", (Object)genericPort);
                }
            }
            if (port == null) {
                if (CollectionUtils.isNotEmpty((Collection)this.ports)) {
                    SwitchPort switchPort = (SwitchPort)PortListUtils.findPortByPortNumber((List)this.ports, (int)portNumber);
                    if (switchPort != null) {
                        SwitchPortEnum type = SwitchPortEnum.valueOf((byte)ByteUtils.getLowByte((int)portState));
                        SwitchPortStatus status = SwitchPortStatus.valueOf((SwitchPortEnum)type);
                        LOGGER.debug("SwitchPort status has changed, port: {}, status: {}", (Object)switchPort, (Object)status);
                        switchPort.setStatus((BidibStatus)status);
                        if (switchPort.isInactive()) {
                            switchPort.setInactive(false);
                            portConfigChanged = true;
                        }
                        port = switchPort;
                    } else {
                        LOGGER.warn("No switch port available for portNumber: {}", (Object)portNumber);
                    }
                }
            } else {
                LOGGER.debug("No switch ports or generic ports available.");
            }
        }
        if (port != null) {
            nodeChangePublisher.firePortStatusChanged(SwitchPort.class, port);
            if (portConfigChanged) {
                nodeChangePublisher.firePortConfigChanged(port);
            }
            this.getPublisher().getSubjectPortEvents().onNext((Object)new PortStatusEvent(this.getPublisher().getConnectionId(), this.getPublisher().getUniqueId().longValue(), port));
        }
    }
}

