/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.node;

import com.jgoodies.binding.beans.Model;
import java.lang.ref.WeakReference;
import java.util.Collection;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchingNode
extends Model
implements SwitchingNodeInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchingNode.class);
    private final WeakReference<NodeInterface> parent;
    private boolean portQueryAllEnabled;

    public SwitchingNode(NodeInterface parent) {
        this.parent = new WeakReference<NodeInterface>(parent);
    }

    public NodeInterface getNode() {
        return (NodeInterface)this.parent.get();
    }

    public boolean isQueryPortStatusEnabled() {
        boolean queryPortStatusEnabled = false;
        try {
            Feature featurePortQuery = Feature.findFeature((Collection)this.getNode().getNode().getFeatures(), (int)66);
            if (featurePortQuery != null) {
                queryPortStatusEnabled = featurePortQuery.getValue() > 0;
            }
            LOGGER.info("Query the port status enabled: {}, featurePortQuery: {}", (Object)queryPortStatusEnabled, (Object)featurePortQuery);
        }
        catch (Exception ex) {
            LOGGER.warn("Check if query the port status is enabled failed.", (Throwable)ex);
            throw new RuntimeException("Check if query the port status is enabled failed.", ex);
        }
        return queryPortStatusEnabled;
    }

    public void setPortQueryAllEnabled(boolean enabled) {
        this.portQueryAllEnabled = enabled;
    }

    public boolean isPortQueryAllEnabled() {
        return this.portQueryAllEnabled;
    }

    public String toString() {
        return this.getNode().toString();
    }
}

