/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script;

import java.util.LinkedList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScriptCommand<T extends Scripting>
implements ScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractScriptCommand.class);
    private final ConsoleService consoleService;
    private final String key;
    protected String line;
    private final String helpHtml;
    protected static final String CODE_BLOCK_START = "<div class=\"codeblock\">";
    protected static final String DIV_END = "</div>";

    protected AbstractScriptCommand(ConsoleService consoleService, String key, String help) {
        this.consoleService = consoleService;
        this.key = key;
        this.helpHtml = help;
    }

    protected static String prepareHelpHtml(String help) {
        String helpHtml = null;
        if (help != null) {
            helpHtml = help.replaceAll("<", "&lt;");
            helpHtml = helpHtml.replaceAll(">", "&gt;");
            helpHtml = helpHtml.replaceAll("\\n", "<br/>");
            Pattern pattern = Pattern.compile("##link\\((.+)\\)");
            Matcher matcher = pattern.matcher(helpHtml);
            while (matcher.find()) {
                String link = matcher.group(1);
                LOGGER.info("Found link: {}", (Object)link);
                helpHtml = helpHtml.replaceAll("##link\\(" + link + "\\)", "<a href=\"" + link + "\">" + link + "</a>");
            }
        }
        return helpHtml;
    }

    protected ConsoleService getConsoleService() {
        return this.consoleService;
    }

    public Optional<String> getHelp() {
        return Optional.ofNullable(this.getHelpHtml());
    }

    public String getKey() {
        return this.key;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getLine() {
        return this.line;
    }

    public String getHelpHtml() {
        return this.helpHtml;
    }

    public void execute(T scripting, ApplicationContext context) {
        LOGGER.info("Execute the command: {}", (Object)this);
        try {
            this.internalExecute(scripting, context);
        }
        catch (ScriptExecutionException ex) {
            LOGGER.warn("Execute command in AWT-thread failed: {}", (Object)ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Execute command in AWT-thread failed.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected void addError(ApplicationContext context, String errorDescription) {
        LinkedList<String> scriptErrors = (LinkedList<String>)context.get("scriptErrors");
        if (scriptErrors == null) {
            scriptErrors = new LinkedList<String>();
            context.register("scriptErrors", scriptErrors);
        }
        LOGGER.warn("Add script error: {}", (Object)errorDescription);
        scriptErrors.add(errorDescription);
    }

    protected abstract void internalExecute(T var1, ApplicationContext var2);

    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.line)) {
            return this.line;
        }
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

