/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.Scripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScriptCommandFactory<T extends Scripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractScriptCommandFactory.class);
    protected final Map<String, Class<? extends ScriptCommand<T>>> scriptCommands = new HashMap<String, Class<? extends ScriptCommand<T>>>();

    public abstract void registerCommands();

    public ScriptCommand<T> parse(String line) {
        Scanner scanner = new Scanner(line);
        String key = scanner.next();
        ScriptCommand<T> command = this.getScriptCommand(key);
        if (command != null) {
            command.parse(line);
        }
        scanner.close();
        return command;
    }

    private ScriptCommand<T> getScriptCommand(String key) {
        Class<ScriptCommand<T>> clazz = this.scriptCommands.get(key);
        if (clazz == null) {
            LOGGER.warn("Command is not registered: {}", (Object)key);
            return null;
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.warn("Create script command class failed.", (Throwable)e);
            return null;
        }
    }
}

