/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script;

import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bidib.wizard.api.context.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptUtils.class);

    public static int[] scanVidPid(Scanner scanner) {
        return ScriptUtils.scanVidPid(scanner, false);
    }

    public static int[] scanVidPid(Scanner scanner, boolean ignoreMissing) {
        String vidPid = null;
        try {
            vidPid = scanner.next("--V\\d+\\:P\\d+");
        }
        catch (InputMismatchException ex) {
            LOGGER.warn("No VID:PID found.");
            if (ignoreMissing) {
                return null;
            }
            throw new IllegalArgumentException("No VID:PID token available.");
        }
        catch (NoSuchElementException ex) {
            LOGGER.warn("No VID:PID found.");
            throw new IllegalArgumentException("No VID:PID token available.");
        }
        LOGGER.info("Current vidPid: {}", (Object)vidPid);
        Pattern pattern = Pattern.compile("--V(\\d+)\\:P(\\d+)");
        Matcher matcher = pattern.matcher(vidPid);
        if (matcher.matches()) {
            int vid = Integer.valueOf(matcher.group(1));
            int pid = Integer.valueOf(matcher.group(2));
            LOGGER.info("VID: {}, PID: {}", (Object)vid, (Object)pid);
            return new int[]{vid, pid};
        }
        throw new IllegalArgumentException("No valid VID:PID token available.");
    }

    public static int parseIntParam(Scanner scanner, String patternString) {
        Matcher matcher;
        Pattern pattern = Pattern.compile(patternString);
        String matching = scanner.findInLine(patternString);
        if (matching != null && (matcher = pattern.matcher(matching)).find()) {
            String cvPair = matcher.group();
            String[] values = cvPair.split("=");
            return Integer.parseInt(values[1]);
        }
        throw new IllegalArgumentException("No value found. Current patternString: " + patternString);
    }

    public static int parseIntParam(String patternString, String line) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String cvPair = matcher.group();
            String[] values = cvPair.split("=");
            return Integer.parseInt(values[1]);
        }
        throw new IllegalArgumentException("No value found. Current patternString: " + patternString);
    }

    public static Integer parseOptionalIntegerParam(String patternString, String line) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String cvPair = matcher.group();
            String[] values = cvPair.split("=");
            return Integer.parseInt(values[1]);
        }
        return null;
    }

    public static String parseStringParam(String patternString, String line) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String stringValue = matcher.group();
            if (stringValue.startsWith("\"") || stringValue.startsWith("'")) {
                stringValue = stringValue.substring(1);
            }
            if (stringValue.endsWith("\"") || stringValue.endsWith("'")) {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
            }
            return stringValue;
        }
        throw new IllegalArgumentException("No value found. Current patternString: " + patternString);
    }

    public static String parseStringParamValue(String patternString, int group, String line) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String stringValue = matcher.group(group);
            if (stringValue.startsWith("\"") || stringValue.startsWith("'")) {
                stringValue = stringValue.substring(1);
            }
            if (stringValue.endsWith("\"") || stringValue.endsWith("'")) {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
            }
            return stringValue;
        }
        throw new IllegalArgumentException("No value found. Current patternString: " + patternString);
    }

    public static String parseOptionalStringParam(String patternString, String line) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String stringValue = matcher.group();
            if (stringValue.startsWith("\"") || stringValue.startsWith("'")) {
                stringValue = stringValue.substring(1);
            }
            if (stringValue.endsWith("\"") || stringValue.endsWith("'")) {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
            }
            return stringValue;
        }
        return null;
    }

    public static Map<String, Object> getParameters(ApplicationContext context) {
        HashMap parameters = (HashMap)context.get("parameters", Map.class);
        if (parameters == null) {
            parameters = new HashMap();
            context.register("parameters", parameters);
        }
        return parameters;
    }
}

