/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.booster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.booster.BoosterScripting;
import org.bidib.wizard.model.status.BoosterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterSetStateCommand
extends AbstractScriptCommand<BoosterScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterSetStateCommand.class);
    public static final String KEY = "boosterSetState";
    public static final String HELP = "<div class=\"codeblock\">boosterSetState" + BoosterSetStateCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] [--uid=<uniqueId>] [off|on]") + "</div>" + BoosterSetStateCommand.prepareHelpHtml("\nSet the booster state. If '--uid' is specified the VID/PID and --all params are ignored. The uniqueId is the hex-encoded uniqueId of the node without the classbits.\n\nExample:\n") + "<div class=\"codeblock\">" + BoosterSetStateCommand.prepareHelpHtml("boosterSetState --uid=0x0D2C000502 on") + "</div>";
    private int[] vidPid;
    private boolean processAllNodes;
    private BoosterStatus requestedStatus;
    private String uniqueId;

    public BoosterSetStateCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    protected String getUniqueId() {
        return this.uniqueId;
    }

    public void parse(String commandLine) {
        this.setLine(commandLine.trim());
        try (Scanner scanner = new Scanner(commandLine);){
            String expectedBoosterStatus;
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.uniqueId = scanner.next("--uid=(0x|0X)?[a-fA-F0-9]+").substring(6);
            }
            catch (Exception ex) {
                LOGGER.info("No uniqueId found. Fallback to VID/PID.");
            }
            if (this.uniqueId == null) {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
                if (this.line.indexOf("--all") > -1) {
                    LOGGER.info("Process all nodes is activated.");
                    this.processAllNodes = true;
                    scanner.next();
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(expectedBoosterStatus = scanner.next()))) {
                this.requestedStatus = BoosterStatus.fromString((String)expectedBoosterStatus);
            }
        }
        LOGGER.info("Current vidPid: {}, requestedStatus: {}", (Object)this.vidPid, (Object)this.requestedStatus);
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    public BoosterStatus getRequestedStatus() {
        return this.requestedStatus;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(BoosterScripting scripting, ApplicationContext context) {
        ArrayList<NodeInterface> nodes = new ArrayList<NodeInterface>();
        if (this.uniqueId != null) {
            long uniqueId = 0L;
            Pattern pattern = Pattern.compile("(0x|0X)?([a-fA-F0-9]+)");
            Matcher matcher = pattern.matcher(this.uniqueId);
            if (!matcher.matches()) {
                this.addError(context, "No UniqueId provided.");
                return;
            }
            String raw = matcher.group(2);
            uniqueId = Long.parseLong(raw, 16);
            LOGGER.info("UniqueId: {}", (Object)uniqueId);
            NodeInterface node = scripting.getNodeByUniqueIdWithoutClassBits(NodeUtils.getUniqueId((long)uniqueId));
            if (node == null) {
                throw new ScriptExecutionException("No matching node with provided uniqueId found.", this);
            }
            nodes.add(node);
        } else if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
                throw new IllegalArgumentException("No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set booster state.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            LOGGER.info("Found node: {}", (Object)node);
            BoosterStatus boosterStatus = node.getBoosterNode().getBoosterStatus();
            LOGGER.info("Current boosterStatus: {}", (Object)boosterStatus);
            scripting.setBoosterStatus(node.getBoosterNode(), this.requestedStatus);
        }
        return;
    }
}

