/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.booster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.StringUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.booster.CommandStationScripting;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandStationDriveCommand
extends AbstractScriptCommand<CommandStationScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandStationDriveCommand.class);
    public static final String KEY = "csDrive";
    public static final String HELP = "<div class=\"codeblock\">csDrive" + CommandStationDriveCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] [--uid=<uniqueId>] --addr=<loco-address> [ --speedSteps=[DCC128|DCC28] ] --direction=[forward|backward] --speed=<speed>") + "</div>" + CommandStationDriveCommand.prepareHelpHtml("\nSet the command station state. If '--uid' is specified the VID/PID and --all params are ignored. The uniqueId is the hex-encoded uniqueId of the node without the classbits.\nIf no speed steps are provided, the DCC128 value is used!\n\nExample:\n") + "<div class=\"codeblock\">" + CommandStationDriveCommand.prepareHelpHtml("csDrive --uid=0x0D2C000502 --addr=3 --direction=forward --speed=23") + "</div>";
    private int[] vidPid;
    private boolean processAllNodes;
    private String uniqueId;
    private int locoAddress = 3;
    private SpeedSteps speedSteps = SpeedSteps.DCC128;
    private int speed = 0;
    private DirectionStatus direction = DirectionStatus.FORWARD;

    public CommandStationDriveCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    protected String getUniqueId() {
        return this.uniqueId;
    }

    public void parse(String commandLine) {
        this.setLine(commandLine.trim());
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.uniqueId = scanner.next("--uid=(0x|0X)?[a-fA-F0-9]+").substring(6);
            }
            catch (Exception ex) {
                LOGGER.info("No uniqueId found. Fallback to VID/PID.");
            }
            if (this.uniqueId == null) {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
                if (this.line.indexOf("--all") > -1) {
                    LOGGER.info("Process all nodes is activated.");
                    this.processAllNodes = true;
                    scanner.next();
                }
            }
            String arguments = this.line.substring(KEY.length() + 1);
            this.locoAddress = ScriptUtils.parseIntParam("--addr=\\d+", arguments);
            this.speed = ScriptUtils.parseIntParam("--speed=\\d+", arguments);
            this.direction = "forward".equals(ScriptUtils.parseStringParam("--direction=\\w+", arguments)) ? DirectionStatus.FORWARD : DirectionStatus.BACKWARD;
            try {
                String speedStepsString = ScriptUtils.parseOptionalStringParam("--speedSteps=\\w+", arguments);
                if (StringUtils.isNotBlank((CharSequence)speedStepsString)) {
                    this.speedSteps = SpeedSteps.parse((String)speedStepsString);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Parse speedSteps failed.", (Throwable)ex);
                throw new IllegalArgumentException("Parse speedSteps failed.");
            }
        }
        LOGGER.info("Current vidPid: {}, locoAddress: {}", (Object)this.vidPid, (Object)this.locoAddress);
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(CommandStationScripting scripting, ApplicationContext context) {
        ArrayList<NodeInterface> nodes = new ArrayList<NodeInterface>();
        if (this.uniqueId != null) {
            long uniqueId = 0L;
            Pattern pattern = Pattern.compile("(0x|0X)?([a-fA-F0-9]+)");
            Matcher matcher = pattern.matcher(this.uniqueId);
            if (!matcher.matches()) {
                this.addError(context, "No UniqueId provided.");
                return;
            }
            String raw = matcher.group(2);
            uniqueId = Long.parseLong(raw, 16);
            LOGGER.info("UniqueId: {}", (Object)uniqueId);
            NodeInterface node = scripting.getNodeByUniqueIdWithoutClassBits(NodeUtils.getUniqueId((long)uniqueId));
            if (node == null) {
                throw new ScriptExecutionException("No matching node with provided uniqueId found.", this);
            }
            nodes.add(node);
        } else if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
                throw new IllegalArgumentException("No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set command station state.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            LOGGER.info("Found node: {}", (Object)node);
            LOGGER.info("Set the speed, locoAddress: {}, speed: {}, direction: {}", new Object[]{this.locoAddress, this.speed, this.direction});
            scripting.setLocoSpeed("main", node.getCommandStationNode(), this.locoAddress, this.speedSteps, this.speed, this.direction);
        }
        return;
    }
}

