/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.booster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.booster.BoosterScripting;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandStationGetStateCommand
extends AbstractScriptCommand<BoosterScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandStationGetStateCommand.class);
    public static final String KEY = "csGetState";
    public static final String HELP = "<div class=\"codeblock\">csGetState" + CommandStationGetStateCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] [--uid=<uniqueId>] <expectedStatus [off|stop|go]>") + "</div>" + CommandStationGetStateCommand.prepareHelpHtml("\nGet the current comamnd station state and compare the expected status. If '--uid' is specified the VID/PID and --all params are ignored. The uniqueId is the hex-encoded uniqueId of the node without the classbits.\n\nExample:\n") + "<div class=\"codeblock\">" + CommandStationGetStateCommand.prepareHelpHtml("csGetState --uid=0x0D2C000502 off") + "</div>";
    private int[] vidPid;
    private boolean processAllNodes;
    private CommandStationStatus expectedStatus;
    private String uniqueId;

    public CommandStationGetStateCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    protected String getUniqueId() {
        return this.uniqueId;
    }

    public void parse(String commandLine) {
        this.setLine(commandLine.trim());
        try (Scanner scanner = new Scanner(commandLine);){
            String expectedCsStatus;
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.uniqueId = scanner.next("--uid=(0x|0X)?[a-fA-F0-9]+").substring(6);
            }
            catch (Exception ex) {
                LOGGER.info("No uniqueId found. Fallback to VID/PID.");
            }
            if (this.uniqueId == null) {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
                if (this.line.indexOf("--all") > -1) {
                    LOGGER.info("Process all nodes is activated.");
                    this.processAllNodes = true;
                    scanner.next();
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(expectedCsStatus = scanner.next()))) {
                this.expectedStatus = CommandStationStatus.fromString((String)expectedCsStatus);
            }
        }
        LOGGER.info("Current vidPid: {}, expectedStatus: {}", (Object)this.vidPid, (Object)this.expectedStatus);
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    public CommandStationStatus getExpectedStatus() {
        return this.expectedStatus;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(BoosterScripting scripting, ApplicationContext context) {
        CommandStationStatus commandStationStatus;
        ArrayList<NodeInterface> nodes = new ArrayList<NodeInterface>();
        if (this.uniqueId != null) {
            long uniqueId = 0L;
            Pattern pattern = Pattern.compile("(0x|0X)?([a-fA-F0-9]+)");
            Matcher matcher = pattern.matcher(this.uniqueId);
            if (!matcher.matches()) {
                this.addError(context, "No UniqueId provided.");
                return;
            }
            String raw = matcher.group(2);
            uniqueId = Long.parseLong(raw, 16);
            LOGGER.info("UniqueId: {}", (Object)uniqueId);
            NodeInterface node = scripting.getNodeByUniqueIdWithoutClassBits(NodeUtils.getUniqueId((long)uniqueId));
            if (node == null) {
                throw new ScriptExecutionException("No matching node with provided uniqueId found.", this);
            }
            nodes.add(node);
        } else if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
                throw new IllegalArgumentException("No matching node with provided VID/PID found, VID: " + this.vidPid[0] + ", PID: " + this.vidPid[1]);
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip query booster state.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        do {
            if (!iterator.hasNext()) {
                return;
            }
            NodeInterface node = (NodeInterface)iterator.next();
            LOGGER.info("Found node: {}", (Object)node);
            commandStationStatus = node.getCommandStationNode().getCommandStationStatus();
            LOGGER.info("Current commandStationStatus: {}", (Object)commandStationStatus);
        } while (commandStationStatus == this.expectedStatus);
        this.addError(context, "The current command station status does not match the expected status.");
        throw new ScriptExecutionException("The current command station status does not match the expected status.", this);
    }
}

