/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortCommand<T extends CommonScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbortCommand.class);
    private static final String REGEX = "([\\\"'])(?:(?=(\\\\?))\\2.)*?\\1";
    public static final String KEY = "abort";
    public static final String HELP = "<div class=\"codeblock\">abort" + AbortCommand.prepareHelpHtml(" [<reason>]") + "</div>" + AbortCommand.prepareHelpHtml("\nAbort script execution. The reason parameter is optional.");
    private String reasonText;

    public AbortCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.reasonText = scanner.findInLine(REGEX);
            if (this.reasonText == null) {
                this.reasonText = scanner.findInLine(".+");
                if (this.reasonText != null) {
                    this.reasonText = this.reasonText.trim();
                }
                if (StringUtils.isBlank((CharSequence)this.reasonText)) {
                    this.reasonText = "Abort execution.";
                }
            } else {
                this.reasonText = this.reasonText.substring(1, this.reasonText.length() - 1);
            }
        }
        LOGGER.info("Parsed command, echoText: {}", (Object)this.reasonText);
    }

    protected String getReasonText() {
        return this.reasonText;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Abort the script execution: {}", (Object)this.reasonText);
        scripting.echo("Abort the script execution: " + this.reasonText);
        throw new ScriptExecutionException("Abort the script execution.");
    }
}

