/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectCommand
extends AbstractScriptCommand<CommonScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectCommand.class);
    public static final String KEY = "connect";
    public static final String HELP = "<div class=\"codeblock\">connect" + ConnectCommand.prepareHelpHtml(" --id=<connectionId>") + "</div>" + ConnectCommand.prepareHelpHtml("\nConnect to BiDiB system. The connectionId is the connection identifier. The standard value is 'main'.\n\nExample:\n") + "<div class=\"codeblock\">" + ConnectCommand.prepareHelpHtml("connect --id=main") + "</div>";
    private String connectionId;

    public ConnectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    protected String getConnectionId() {
        return this.connectionId;
    }

    public void parse(String commandLine) {
        this.setLine(commandLine.trim());
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.connectionId = scanner.next("--id=(.+)").substring(5);
            }
            catch (Exception ex) {
                LOGGER.warn("No connectionId found.", (Throwable)ex);
                throw new RuntimeException("connect: No connectionId found.");
            }
        }
        LOGGER.info("Current connectionId: {}", (Object)this.connectionId);
    }

    @Override
    protected void internalExecute(CommonScripting scripting, ApplicationContext context) {
        if (StringUtils.isBlank((CharSequence)this.connectionId)) {
            throw new ScriptExecutionException("No connectionId provided.", this);
        }
        try {
            scripting.connect(this.connectionId);
        }
        catch (Exception ex) {
            LOGGER.warn("Connect failed.", (Throwable)ex);
            throw new ScriptExecutionException("Connect to BiDiB system failed: " + ex.getMessage(), this);
        }
    }
}

