/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.script.ScriptOptionAwareCommand;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectCommand
extends AbstractScriptCommand<CommonScripting>
implements ScriptOptionAwareCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectCommand.class);
    public static final String KEY = "disconnect";
    public static final String HELP = "<div class=\"codeblock\">disconnect" + DisconnectCommand.prepareHelpHtml(" --id=<connectionId>") + "</div>" + DisconnectCommand.prepareHelpHtml("\nDisconnect from BiDiB system. The connectionId is the connection identifier. The standard value is 'main'.\n\nExample:\n") + "<div class=\"codeblock\">" + DisconnectCommand.prepareHelpHtml("disconnect --id=main") + "</div>";
    private String connectionId;

    public DisconnectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    protected String getConnectionId() {
        return this.connectionId;
    }

    public String getOptionKey() {
        return "disconnectOnError";
    }

    public void parse(String commandLine) {
        this.setLine(commandLine.trim());
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.connectionId = scanner.next("--id=(.+)").substring(5);
            }
            catch (Exception ex) {
                LOGGER.warn("No connectionId found.", (Throwable)ex);
                throw new RuntimeException("disconnect: No connectionId found.");
            }
        }
        LOGGER.info("Current connectionId: {}", (Object)this.connectionId);
    }

    @Override
    protected void internalExecute(CommonScripting scripting, ApplicationContext context) {
        if (StringUtils.isBlank((CharSequence)this.connectionId)) {
            throw new ScriptExecutionException("No connectionId provided.", this);
        }
        try {
            scripting.disconnect(this.connectionId);
            this.getConsoleService().addConsoleLine(ConsoleColor.gray, "Disconnect passed.");
        }
        catch (Exception ex) {
            LOGGER.warn("Connect failed.", (Throwable)ex);
            throw new ScriptExecutionException("Disconnect from BiDiB system failed: " + ex.getMessage(), this);
        }
    }
}

