/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoAndShowConfirmDialogCommand<T extends CommonScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoAndShowConfirmDialogCommand.class);
    private static final String REGEX = "([\\\"'])(?:(?=(\\\\?))\\2.)*?\\1";
    public static final String KEY = "echoAndShowConfirmDialog";
    public static final String HELP = "<div class=\"codeblock\">echoAndShowConfirmDialog" + EchoAndShowConfirmDialogCommand.prepareHelpHtml(" [--timeout=<timeout>] <Text to display in dialog>") + "</div>" + EchoAndShowConfirmDialogCommand.prepareHelpHtml("\nShow a dialog with the provided message and OK and Cancel options.\nThe optional timeout parameter is the time to show the dialog in seconds. If timeout is not specified, the dialog is not closed automatically.");
    private int timeout;
    private String dialogMessage;
    private final Pattern p = Pattern.compile("\\$\\{.+\\}");

    public EchoAndShowConfirmDialogCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.timeout = ScriptUtils.parseIntParam(scanner, "--timeout=\\d+");
            }
            catch (IllegalArgumentException iaEx) {
                LOGGER.warn("Parse timeout value failed.", (Throwable)iaEx);
                this.timeout = -1;
            }
            this.dialogMessage = scanner.findInLine(REGEX);
            this.dialogMessage = this.dialogMessage == null ? scanner.findInLine(".+").trim() : this.dialogMessage.substring(1, this.dialogMessage.length() - 1);
        }
        LOGGER.info("Parsed command, timeout: {}, dialogMessage: {}", (Object)this.timeout, (Object)this.dialogMessage);
    }

    protected String getDialogMessage() {
        return this.dialogMessage;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        NodeInterface node;
        boolean continueTasks;
        LOGGER.info("Show confirm dialog with text: {}", (Object)this.dialogMessage);
        String dialogMessage = this.dialogMessage;
        Matcher matcher = this.p.matcher(this.dialogMessage);
        if (matcher.find()) {
            LOGGER.info("Detected placeholders in string: {}", (Object)this.dialogMessage);
            Map parameters = (Map)context.get("parameters", Map.class);
            StringSubstitutor sub = new StringSubstitutor(parameters);
            dialogMessage = sub.replace(this.dialogMessage);
        }
        if (!(continueTasks = scripting.echoAndShowConfirmDialog((node = (NodeInterface)context.get("selectedNode", NodeInterface.class)).getUniqueId(), this.timeout, dialogMessage))) {
            LOGGER.warn("The script execution is aborted by user.");
            throw new ScriptExecutionException("Script execution is aborted from dialog.", this);
        }
    }
}

