/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoCommand<T extends CommonScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoCommand.class);
    private static final String REGEX = "([\\\"'])(?:(?=(\\\\?))\\2.)*?\\1";
    public static final String KEY = "echo";
    public static final String HELP = "<div class=\"codeblock\">echo" + EchoCommand.prepareHelpHtml(" <Text to display>") + "</div>" + EchoCommand.prepareHelpHtml("\nShow a message in the script console window.\nSupport for placeholder substitution is available with ${...}.\n\nExample:\n") + "<div class=\"codeblock\">" + EchoCommand.prepareHelpHtml("echo \"Show my MAC address: ${macAddress}\"") + "</div>";
    private String echoText;
    private final Pattern p = Pattern.compile("\\$\\{.+\\}");

    public EchoCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.echoText = scanner.findInLine(REGEX);
            this.echoText = this.echoText == null ? scanner.findInLine(".+").trim() : this.echoText.substring(1, this.echoText.length() - 1);
        }
        LOGGER.info("Parsed command, echoText: {}", (Object)this.echoText);
    }

    protected String getEchoText() {
        return this.echoText;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Echo the text: {}", (Object)this.echoText);
        Matcher matcher = this.p.matcher(this.echoText);
        if (matcher.find()) {
            LOGGER.info("Detected placeholders in string: {}", (Object)this.echoText);
            Map parameters = (Map)context.get("parameters", Map.class);
            StringSubstitutor sub = new StringSubstitutor(parameters);
            String resolvedString = sub.replace(this.echoText);
            scripting.echo(resolvedString);
        } else {
            scripting.echo(this.echoText);
        }
    }
}

