/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateAndAssertCommand<T extends CommonScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateAndAssertCommand.class);
    public static final String KEY = "evaluateAndAssert";
    public static final String HELP = "<div class=\"codeblock\">evaluateAndAssert" + EvaluateAndAssertCommand.prepareHelpHtml(" --paramName=<parameter name> --regex=<regex> --eval=<evaluation>") + "</div>" + EvaluateAndAssertCommand.prepareHelpHtml("\nEvaluate the value of the context parameter.\nThe value is extracted from the parameter value with the regex. The evaluation is a JEXL expression.\n\nExample:\n") + "<div class=\"codeblock\">" + EvaluateAndAssertCommand.prepareHelpHtml("evaluateAndAssert --paramName=\"lastResult\" --regex=\"U=(\\d+)mV\" --eval=\"val > 12000 && val < 14000\"") + "</div>" + EvaluateAndAssertCommand.prepareHelpHtml("\nSee also ##link(https://commons.apache.org/proper/commons-jexl/reference/syntax.html)");
    private String paramName;
    private String regex;
    private String evaluation;

    public EvaluateAndAssertCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            this.paramName = ScriptUtils.parseStringParamValue("--paramName=(\\S+)", 1, arguments);
            this.regex = ScriptUtils.parseStringParamValue("--regex=(\\S+)", 1, arguments);
            this.evaluation = ScriptUtils.parseStringParamValue("--eval=(.+)", 1, arguments);
        }
        LOGGER.info("Parsed command, paramName: {}, regex: {}, eval: {}", new Object[]{this.paramName, this.regex, this.evaluation});
    }

    protected String getParamName() {
        return this.paramName;
    }

    protected String getRegex() {
        return this.regex;
    }

    protected String getEvaluation() {
        return this.evaluation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Evaluate the paramName: {}", (Object)this.paramName);
        Map parameters = (Map)context.get("parameters", Map.class);
        Object val = parameters.get(this.paramName);
        if (!(val instanceof String)) return;
        String value = (String)val;
        Pattern p = Pattern.compile(this.regex);
        Matcher matcher = p.matcher(value);
        if (matcher.find()) {
            String stringValue = matcher.group(1);
            LOGGER.info("Found value: {}", (Object)stringValue);
            JexlEngine jexl = new JexlBuilder().create();
            JexlExpression expression = jexl.createExpression(this.evaluation);
            MapContext jexlContext = new MapContext();
            jexlContext.set("val", (Object)stringValue);
            Object result = expression.evaluate((JexlContext)jexlContext);
            if (result instanceof Boolean) {
                boolean valid = (Boolean)result;
                LOGGER.info("Result is valid: {}", (Object)valid);
                if (valid) return;
                throw new ScriptExecutionException("The validation of the value failed!");
            }
            LOGGER.warn("Evaluate the expression failed.");
            throw new ScriptExecutionException("Evaluate the expression failed.");
        }
        LOGGER.warn("No value found that matches the regex: {}", (Object)this.regex);
    }
}

