/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import org.apache.commons.text.StringSubstitutor;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteProcessCommand<T extends CommonScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteProcessCommand.class);
    private static final String REGEX = "([\\\"'])(?:(?=(\\\\?))\\2.)*?\\1";
    private static final String REGEX_PARAMS = "(\\\"[^\\\"]+\\\"|[^\\s\\\"]+)";
    public static final String KEY = "exec";
    public static final String HELP = "<div class=\"codeblock\">exec" + ExecuteProcessCommand.prepareHelpHtml(" \"<executable>\" [<parameters>]") + "</div>" + ExecuteProcessCommand.prepareHelpHtml("\nExample:\n") + "<div class=\"codeblock\">" + ExecuteProcessCommand.prepareHelpHtml("exec \"cmd.exe\" /V /C \"echo %COMPUTERNAME%\"") + "</div>";
    private String executable;
    private List<String> parameters = new ArrayList<String>();

    public ExecuteProcessCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            String parameter;
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.executable = scanner.findInLine(REGEX);
            if (this.executable == null) {
                this.executable = scanner.findInLine(".+").trim();
            }
            do {
                if ((parameter = scanner.findInLine(REGEX_PARAMS)) == null && (parameter = scanner.findInLine(".+")) != null) {
                    parameter = parameter.trim();
                }
                if (parameter == null) continue;
                this.parameters.add(parameter);
            } while (parameter != null);
        }
        LOGGER.info("Parsed command, executable: {}, parameters: {}", (Object)this.executable, this.parameters);
    }

    protected String getExecutable() {
        return this.executable;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        if (node == null) {
            LOGGER.warn("No node selected.");
            throw new IllegalArgumentException("No node selected.");
        }
        long uniqueId = node.getUniqueId();
        HashMap<String, String> replacementStrings = new HashMap<String, String>();
        int decimalSerialNumber = ByteUtils.getInt((byte)ByteUtils.getHighByte((int)((int)uniqueId)), (byte)ByteUtils.getLowByte((int)((int)uniqueId)));
        replacementStrings.putAll(Map.of("SERIAL", Integer.toString(ByteUtils.getMaskedValue((int)((int)uniqueId), (int)4095)), "SERIALDEC", Integer.toString(decimalSerialNumber), "XSER0", ByteUtils.byteToHex((byte)ByteUtils.getHighByte((int)((int)uniqueId))), "XSER1", ByteUtils.byteToHex((byte)ByteUtils.getLowByte((int)((int)uniqueId)))));
        Map parametersMap = (Map)context.get("parameters", Map.class);
        if (parametersMap != null) {
            for (Map.Entry entry : parametersMap.entrySet()) {
                if (entry.getValue() == null) continue;
                replacementStrings.put((String)entry.getKey(), Objects.toString(entry.getValue()));
            }
        }
        LOGGER.info("Prepared replacement map: {}", replacementStrings);
        StringSubstitutor sub = new StringSubstitutor(replacementStrings, "%", "%");
        ArrayList<String> params = new ArrayList<String>();
        for (String param : this.parameters) {
            String replaced = sub.replace(param);
            LOGGER.info("Replaced parameter: {}", (Object)replaced);
            params.add(replaced);
        }
        scripting.execute(this.executable, params);
    }
}

