/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.common.CommonScripting;
import org.bidib.wizard.common.script.common.WaitCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptOptionCommand
extends AbstractScriptCommand<CommonScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitCommand.class);
    public static final String KEY = "scriptOption";
    public static final String HELP = "<div class=\"codeblock\">scriptOption" + ScriptOptionCommand.prepareHelpHtml(" --set=<optionIdentifier>:<optionValue>") + "</div>" + ScriptOptionCommand.prepareHelpHtml("\nSet a script option that is evaluated by script execution.");
    private String optionIdentifier;
    private String optionValue;

    public ScriptOptionCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                String option = scanner.next("--set=(.+)").substring(6);
                Pattern pattern = Pattern.compile("(\\S+)\\:(\\S+)");
                Matcher matcher = pattern.matcher(option);
                if (matcher.find()) {
                    this.optionIdentifier = matcher.group(1);
                    this.optionValue = matcher.group(2);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("No option to set found found.", (Throwable)ex);
                throw new RuntimeException("No option to set found.");
            }
        }
        LOGGER.info("Parsed command, optionIdentifier: {}", (Object)this.optionIdentifier);
    }

    public String getOptionIdentifier() {
        return this.optionIdentifier;
    }

    public String getOptionValue() {
        return this.optionValue;
    }

    @Override
    public void execute(CommonScripting scripting, ApplicationContext context) {
        LOGGER.info("Register option in context, identifier: {}, value: {}", (Object)this.optionIdentifier, (Object)this.optionValue);
        Map options = (Map)context.get("options", Map.class);
        options.put(this.optionIdentifier, this.optionValue);
    }

    @Override
    protected void internalExecute(CommonScripting scripting, ApplicationContext context) {
    }
}

