/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.List;
import java.util.Scanner;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.switching.NodeTreeScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFirstNodeCommand
extends AbstractScriptCommand<NodeTreeScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectFirstNodeCommand.class);
    public static final String KEY = "selectFirstNode";
    public static final String HELP = "<div class=\"codeblock\">selectFirstNode" + SelectFirstNodeCommand.prepareHelpHtml(" --V<vid>:P<pid>") + "</div>" + SelectFirstNodeCommand.prepareHelpHtml("\nSelect the first node that matches the povided VID and PID in the node list. Be careful if multiple nodes are connected.\nUse selectNode to specify the node by uniqueId.\n\nExample:\n") + "<div class=\"codeblock\">" + SelectFirstNodeCommand.prepareHelpHtml("selectFirstNode --V251:P202") + "</div>";
    private int[] vidPid;

    public SelectFirstNodeCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        block9: {
            this.setLine(commandLine.trim());
            try (Scanner scanner = new Scanner(commandLine);){
                if (!this.getKey().equals(scanner.next())) {
                    LOGGER.info("Invalid command is scanned, key does not match.");
                    throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
                }
                this.line = commandLine.trim();
                try {
                    this.vidPid = ScriptUtils.scanVidPid(scanner, false);
                    if (this.vidPid != null) {
                        LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                        break block9;
                    }
                    throw new IllegalArgumentException("Parse VID/PID failed.");
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                    throw new IllegalArgumentException("Parse VID/PID failed. Make sure to use correct format.\n" + this.getHelpHtml());
                }
            }
        }
        LOGGER.info("Current vidPid: {}", (Object)this.vidPid);
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    @Override
    protected void internalExecute(NodeTreeScripting scripting, ApplicationContext context) {
        if (this.vidPid == null) {
            this.addError(context, "No VID/PID provided.");
            throw new ScriptExecutionException("No VID/PID provided.", this);
        }
        int vid = this.vidPid[0];
        int pid = this.vidPid[1];
        List<NodeInterface> nodes = scripting.getNodesByVidAndPid(vid, pid);
        if (CollectionUtils.isEmpty(nodes)) {
            throw new ScriptExecutionException("No matching node with provided VID/PID found.", this);
        }
        NodeInterface node = nodes.get(0);
        LOGGER.info("Register the selected node: {}", (Object)node);
        context.register("selectedNode", (Object)node);
        scripting.echo("Selected node: " + ByteUtils.getUniqueIdAsString((long)node.getUniqueId()));
    }
}

