/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.switching.NodeTreeScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectNodeCommand
extends AbstractScriptCommand<NodeTreeScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectNodeCommand.class);
    public static final String KEY = "selectNode";
    public static final String HELP = "<div class=\"codeblock\">selectNode" + SelectNodeCommand.prepareHelpHtml(" --uid=<uniqueId>") + "</div>" + SelectNodeCommand.prepareHelpHtml("\nThe uniqueId is the hex-encoded uniqueId of the node without the classbits. The value starts with '0x'.\n\nExample:\n") + "<div class=\"codeblock\">" + SelectNodeCommand.prepareHelpHtml("selectNode --uid=0x0D2C000502") + "</div>";
    private String uniqueId;

    public SelectNodeCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    protected String getUniqueId() {
        return this.uniqueId;
    }

    public void parse(String commandLine) {
        this.setLine(commandLine.trim());
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.uniqueId = scanner.next("--uid=(0x|0X)?[a-fA-F0-9]+").substring(6);
            }
            catch (Exception ex) {
                LOGGER.warn("No uniqueId found.");
                throw new RuntimeException("selectNode: No uniqueId found.");
            }
        }
        LOGGER.info("Current uniqueId: {}", (Object)this.uniqueId);
    }

    @Override
    protected void internalExecute(NodeTreeScripting scripting, ApplicationContext context) {
        long uniqueId = 0L;
        Pattern pattern = Pattern.compile("(0x|0X)?([a-fA-F0-9]+)");
        Matcher matcher = pattern.matcher(this.uniqueId);
        if (!matcher.matches()) {
            this.addError(context, "No UniqueId provided.");
            return;
        }
        String raw = matcher.group(2);
        uniqueId = Long.parseLong(raw, 16);
        LOGGER.info("UniqueId: {}", (Object)uniqueId);
        NodeInterface node = scripting.getNodeByUniqueIdWithoutClassBits(NodeUtils.getUniqueId((long)uniqueId));
        if (node == null) {
            throw new ScriptExecutionException("No matching node with provided uniqueId found.", this);
        }
        LOGGER.info("Register the selected node: {}", (Object)node);
        context.register("selectedNode", (Object)node);
    }
}

