/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.common;

import java.util.Scanner;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitCommand<T extends Scripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitCommand.class);
    public static final String KEY = "wait";
    public static final String HELP = "<div class=\"codeblock\">wait" + WaitCommand.prepareHelpHtml(" <duration [ms]>") + "</div>" + WaitCommand.prepareHelpHtml("\nWait with script execution for configured duration.");
    private int wait;

    public WaitCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.wait = scanner.nextInt();
        }
        LOGGER.info("Parsed command, wait: {}", (Object)this.wait);
    }

    public int getWait() {
        return this.wait;
    }

    @Override
    public void execute(T scripting, ApplicationContext context) {
        try {
            Thread.sleep(this.wait);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Sleep was interrupted.");
        }
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
    }
}

