/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.debug;

import java.util.Scanner;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.debug.DebugInterfaceScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectDebugCommand
extends AbstractScriptCommand<DebugInterfaceScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectDebugCommand.class);
    public static final String KEY = "connectDebugInterface";
    private String connectionId;
    private String portIdentifier;
    private Integer baudRate;
    public static final String HELP = "<div class=\"codeblock\">connectDebugInterface" + ConnectDebugCommand.prepareHelpHtml(" --id=<connectionId> [--port=<port identifier>] [--baudRate=<baud rate>]") + "</div>" + ConnectDebugCommand.prepareHelpHtml("\nConnect to debug interface. The connectionId is the connection identifier. The standard value is 'DebugMain'.\n\nExample:\n") + "<div class=\"codeblock\">" + ConnectDebugCommand.prepareHelpHtml("connectDebugInterface --id=DebugMain\n") + ConnectDebugCommand.prepareHelpHtml("connectDebugInterface --id=DebugMain --port=COM10 --baudRate=115200") + "</div>";

    public ConnectDebugCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.warn("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.connectionId = ScriptUtils.parseStringParam("(?<=--id=)(?s)(\\w+)", arguments);
            }
            catch (Exception ex) {
                LOGGER.warn("No connectionId found.", (Throwable)ex);
                throw new RuntimeException("connect: No connectionId found.");
            }
            this.portIdentifier = ScriptUtils.parseOptionalStringParam("(?<=--port=)(?s)(\\w+)", arguments);
            this.baudRate = ScriptUtils.parseOptionalIntegerParam("--baudRate=\\d+", arguments);
        }
        LOGGER.info("Parsed command, connectionId: {}", (Object)this.connectionId);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getPortIdentifier() {
        return this.portIdentifier;
    }

    public Integer getBaudRate() {
        return this.baudRate;
    }

    @Override
    protected void internalExecute(DebugInterfaceScripting scripting, ApplicationContext context) {
        LOGGER.info("Connect to debug interface with connectionId: {}", (Object)this.connectionId);
        scripting.connectDebug(this.connectionId, this.portIdentifier, this.baudRate);
    }
}

