/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.debug;

import java.util.Scanner;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.debug.DebugInterfaceScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectDebugCommand
extends AbstractScriptCommand<DebugInterfaceScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectDebugCommand.class);
    public static final String KEY = "disconnectDebugInterface";
    private String connectionId;
    public static final String HELP = "<div class=\"codeblock\">disconnectDebugInterface" + DisconnectDebugCommand.prepareHelpHtml(" --id=<connectionId>") + "</div>" + DisconnectDebugCommand.prepareHelpHtml("\nDisconnect from debug interface. The connectionId is the connection identifier. The standard value is 'DebugMain'.\n\nExample:\n") + "<div class=\"codeblock\">" + DisconnectDebugCommand.prepareHelpHtml("disconnectDebugInterface --id=DebugMain") + "</div>";

    public DisconnectDebugCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.warn("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            try {
                this.connectionId = scanner.next("--id=(.+)").substring(5);
            }
            catch (Exception ex) {
                LOGGER.warn("No connectionId found.", (Throwable)ex);
                throw new RuntimeException("disconnect: No connectionId found.");
            }
        }
        LOGGER.info("Parsed command, connectionId: {}", (Object)this.connectionId);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    protected void internalExecute(DebugInterfaceScripting scripting, ApplicationContext context) {
        LOGGER.info("Disconnect from debug interface with connectionId: {}", (Object)this.connectionId);
        scripting.disconnectDebug(this.connectionId);
    }
}

