/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.debug;

import java.util.Scanner;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.debug.DebugInterfaceScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDebugTextCommand
extends AbstractScriptCommand<DebugInterfaceScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendDebugTextCommand.class);
    public static final String KEY = "sendDebugText";
    private String message;
    public static final String HELP = "<div class=\"codeblock\">sendDebugText" + SendDebugTextCommand.prepareHelpHtml(" --text=\"<text to send>\"") + "</div>" + SendDebugTextCommand.prepareHelpHtml("\nSend a string to the debug interface.\n\nExample:\n") + "<div class=\"codeblock\">" + SendDebugTextCommand.prepareHelpHtml("sendDebugText --text=\"info\"") + "</div>";

    public SendDebugTextCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.warn("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.message = ScriptUtils.parseStringParam("(?<=--text=)(?s)(.*$)", arguments);
            }
            catch (Exception ex) {
                LOGGER.warn("No connectionId found.", (Throwable)ex);
                throw new RuntimeException("send text: No message found.");
            }
        }
        LOGGER.info("Parsed command, message: {}", (Object)this.message);
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    protected void internalExecute(DebugInterfaceScripting scripting, ApplicationContext context) {
        LOGGER.info("Connect to debug interface with message: {}", (Object)this.message);
        scripting.sendDebugText(this.message);
    }
}

