/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.engine;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.ScriptEngineListener;
import org.bidib.wizard.api.script.ScriptOptionAwareCommand;
import org.bidib.wizard.api.script.ScriptStatus;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngine<T extends Scripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptEngine.class);
    private final Object scriptWorkerLock = new Object();
    private Future<?> scriptWorker;
    private AtomicBoolean scriptRunning = new AtomicBoolean(false);
    private AtomicBoolean scriptRepeating = new AtomicBoolean(false);
    private List<ScriptCommand<T>> scriptCommands;
    private T scripting;
    private final ApplicationContext context;
    private List<ScriptEngineListener<T>> engineListeners = new LinkedList<ScriptEngineListener<T>>();
    private final ScheduledExecutorService scriptEngineWorkers = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("scriptEngineWorkers-thread-%d").build());
    private ScriptStatus scriptStatus = ScriptStatus.STOPPED;

    public ScriptEngine(T scripting, ApplicationContext context) {
        this.scripting = scripting;
        this.context = context;
    }

    public void addScriptEngineListener(ScriptEngineListener<T> listener) {
        this.engineListeners.add(listener);
    }

    public void removeScriptEngineListener(ScriptEngineListener<T> listener) {
        this.engineListeners.remove(listener);
    }

    public void setScriptRepeating(boolean repeating) {
        this.scriptRepeating.set(repeating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScriptCommands(List<ScriptCommand<T>> scriptCommands) {
        LOGGER.info("Set the new script commands.");
        Object object = this.scriptWorkerLock;
        synchronized (object) {
            if (this.scriptRunning.get()) {
                LOGGER.warn("The script engine is currently processing commands. Stop the engine before setting new commands.");
                throw new IllegalStateException("The script engine is currently processing commands. Stop the engine before setting new commands.");
            }
            this.scriptCommands = scriptCommands;
        }
    }

    public boolean hasScriptCommands() {
        return CollectionUtils.isNotEmpty(this.scriptCommands);
    }

    public void startScript() {
        this.startStepScript(cmd -> Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStepScript(Function<ScriptCommand<T>, Boolean> beforeStepCallback) {
        Object object = this.scriptWorkerLock;
        synchronized (object) {
            if (this.scriptCommands != null && this.scriptWorker == null) {
                LOGGER.info("Create and start scriptWorker.");
                this.scriptRunning.set(true);
                this.signalScriptStatus(ScriptStatus.RUNNING);
                this.scriptWorker = this.scriptEngineWorkers.submit(() -> {
                    LOGGER.info("Start execution of script commands.");
                    try {
                        int currentExecution = 1;
                        do {
                            if (currentExecution > 1) {
                                this.scripting.echo("Repeating execution: " + currentExecution);
                            }
                            for (ScriptCommand<T> command : this.scriptCommands) {
                                if (!this.scriptRunning.get() || Thread.currentThread().isInterrupted()) {
                                    LOGGER.info("Script execution is stopped.");
                                    break;
                                }
                                this.processCommand(command, beforeStepCallback);
                            }
                            ++currentExecution;
                        } while (this.scriptRepeating.get() && this.scriptRunning.get());
                        if (this.context.get("scriptErrors") != null) {
                            LOGGER.warn("Script errors detected: {}", this.context.get("scriptErrors"));
                            this.signalScriptStatus(ScriptStatus.FINISHED_WITH_ERRORS);
                        } else {
                            this.signalScriptStatus(ScriptStatus.FINISHED);
                        }
                    }
                    catch (ScriptExecutionException ex) {
                        LOGGER.warn("Executing script command has failed. Set the scriptStatus to aborted. Failing script command: {}", ex.getScriptCommand(), (Object)ex);
                        if (ex.getScriptCommand() != null) {
                            this.addError(this.context, ex.getMessage() + " - Failing command: " + ex.getScriptCommand());
                        } else {
                            this.addError(this.context, ex.getMessage());
                        }
                        this.signalScriptStatus(ScriptStatus.ABORTED);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Executing script command has failed. Set the scriptStatus to aborted.", (Throwable)ex);
                        this.addError(this.context, ex.getMessage());
                        this.signalScriptStatus(ScriptStatus.ABORTED);
                    }
                    finally {
                        LOGGER.info("Script worker has finished.");
                        this.checkOptions(this.context, beforeStepCallback);
                        this.scriptRunning.set(false);
                        LOGGER.info("Release the script worker.");
                        this.scriptWorker = null;
                    }
                });
                LOGGER.info("Start script worker has passed.");
            } else if (this.scriptWorker != null) {
                LOGGER.warn("Script worker is still running.");
            }
        }
    }

    protected void checkOptions(ApplicationContext context, Function<ScriptCommand<T>, Boolean> beforeStepCallback) {
        Map options = (Map)context.get("options", Map.class);
        if (!options.isEmpty()) {
            try {
                boolean disconnectOnError;
                Object optionDisconnectOnError = options.get("disconnectOnError");
                if (optionDisconnectOnError instanceof String && (disconnectOnError = Boolean.parseBoolean((String)optionDisconnectOnError))) {
                    LOGGER.info("Disconnect on error is enabled.");
                    if (ScriptStatus.ABORTED == this.scriptStatus) {
                        ScriptCommand disconnectCommand = this.scriptCommands.stream().filter(cmd -> cmd instanceof ScriptOptionAwareCommand).filter(cmd -> "disconnectOnError".equals(((ScriptOptionAwareCommand)cmd).getOptionKey())).findFirst().orElse(null);
                        if (disconnectCommand != null) {
                            LOGGER.info("Submit the disconnect command for execution: {}", (Object)disconnectCommand);
                            this.scriptEngineWorkers.submit(() -> this.processCommand(disconnectCommand, beforeStepCallback));
                        } else {
                            LOGGER.warn("No disconnect command configured.");
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Evaluate options failed.", (Throwable)ex);
            }
        }
    }

    private void processCommand(ScriptCommand<T> command, Function<ScriptCommand<T>, Boolean> beforeStepCallback) {
        this.updateCurrentCommand(command);
        if (!beforeStepCallback.apply(command).booleanValue()) {
            LOGGER.warn("Execution of steps was aborted by user in beforeStepCallback.");
            throw new ScriptExecutionException("Execution of steps was aborted by user.", command);
        }
        command.execute(this.scripting, this.context);
    }

    protected void addError(ApplicationContext context, String errorDescription) {
        LinkedList<String> scriptErrors = (LinkedList<String>)context.get("scriptErrors");
        if (scriptErrors == null) {
            scriptErrors = new LinkedList<String>();
            context.register("scriptErrors", scriptErrors);
        }
        LOGGER.info("Add script error: {}", (Object)errorDescription);
        scriptErrors.add(errorDescription);
    }

    public void stopScript() {
        this.stopScript(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScript(Long waitForTermination) {
        this.scriptRunning.set(false);
        LOGGER.info("Stop the script.");
        Object object = this.scriptWorkerLock;
        synchronized (object) {
            if (this.scriptWorker != null) {
                LOGGER.info("Interrupt the script worker: {}", this.scriptWorker);
                boolean successful = this.scriptWorker.cancel(true);
                LOGGER.info("Interrupt the script worker was successful: {}", (Object)successful);
                if (waitForTermination != null) {
                    long waitTime = waitForTermination;
                    LOGGER.info("Wait for termination of script worker for {}ms", (Object)waitTime);
                    try {
                        this.scriptWorker.get(waitTime, TimeUnit.MILLISECONDS);
                    }
                    catch (CancellationException ex) {
                        LOGGER.warn("Wait for termination of script worker has finished with CancellationException.");
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException ex) {
                        LOGGER.warn("Wait for termination of script worker was interrupted.", (Throwable)ex);
                    }
                    this.scriptWorker = null;
                } else {
                    LOGGER.info("Do not wait for termination of script worker.");
                }
            } else {
                LOGGER.info("Script worker is not available.");
            }
        }
    }

    private void signalScriptStatus(ScriptStatus scriptStatus) {
        this.scriptStatus = scriptStatus;
        for (ScriptEngineListener<T> listener : this.engineListeners) {
            listener.scriptStatusChanged(scriptStatus);
        }
    }

    private void updateCurrentCommand(ScriptCommand<T> command) {
        for (ScriptEngineListener<T> listener : this.engineListeners) {
            listener.currentCommandChanged(command);
        }
    }
}

