/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.PortsProvider;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.PortAction;
import org.bidib.wizard.api.script.InitializingCommand;
import org.bidib.wizard.api.script.ScriptProcessingException;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.highlight.BidibScriptScanner;
import org.bidib.wizard.common.highlight.Scanner;
import org.bidib.wizard.common.highlight.Token;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.node.FunctionAware;
import org.bidib.wizard.common.script.node.NodeScriptUtils;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.NumberAware;
import org.bidib.wizard.common.script.node.StringValueCallback;
import org.bidib.wizard.common.script.node.types.BacklightPortType;
import org.bidib.wizard.common.script.node.types.FeedbackPortType;
import org.bidib.wizard.common.script.node.types.InputPortType;
import org.bidib.wizard.common.script.node.types.LightPortType;
import org.bidib.wizard.common.script.node.types.MotorPortType;
import org.bidib.wizard.common.script.node.types.ServoPortType;
import org.bidib.wizard.common.script.node.types.SoundPortType;
import org.bidib.wizard.common.script.node.types.SwitchPairPortType;
import org.bidib.wizard.common.script.node.types.SwitchPortType;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPortCommand
extends AbstractScriptCommand<NodeScripting>
implements FunctionAware,
InitializingCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPortCommand.class);
    public static final String KEY = "configPort";
    public static final String HELP = "<div class=\"codeblock\">configPort" + ConfigPortCommand.prepareHelpHtml(" ptype=<switch|switchpair|...> number=<port number> [switchControl=<switch control>] [loadtype=<load type>] [ticks=<ticks>] ") + "</div>" + ConfigPortCommand.prepareHelpHtml("\nConfigure a port.\n\nExample:\n") + "<div class=\"codeblock\">" + ConfigPortCommand.prepareHelpHtml("configPort ptype=switchpair number=0 loadtype=3 ticks=5") + "</div>" + ConfigPortCommand.prepareHelpHtml("This will configure port number 0 as switchpair port with loadtype=3 and 5 ticks.") + "\n\n<div class=\"codeblock\">" + ConfigPortCommand.prepareHelpHtml("configPort ptype=switch number=0 switchControl=2 loadtype=3 ticks=5") + "</div>" + ConfigPortCommand.prepareHelpHtml("This will configure port number 0 as switch port with switchControl=2 (Z) loadtype=3 and 5 ticks.");
    private Long uuid;
    private Function<? extends BidibStatus> function;
    private String portLabel;
    private Integer portNumber;
    private Map<Byte, PortConfigValue<?>> portConfig = new HashMap();

    public ConfigPortCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public ConfigPortCommand(ConsoleService consoleService, Long uuid) {
        super(consoleService, KEY, HELP);
        this.uuid = uuid;
    }

    @Override
    public void setFunction(Function<BidibStatus> function) {
        this.function = function;
    }

    public Function<? extends BidibStatus> getFunction() {
        return this.function;
    }

    public String getPortLabel() {
        return this.portLabel;
    }

    public void setPortLabel(String portLabel) {
        this.portLabel = portLabel;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    public void parse(String commandLine) {
        LOGGER.info("Parse the command line: {}", (Object)commandLine);
        this.setLine(commandLine.trim());
    }

    private void parseAndEvaluateLine(String line, ApplicationContext context) {
        int oldLen = -1;
        context.register("$$currentLine", (Object)line);
        NodeInterface selectedNode = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        this.uuid = selectedNode.getUniqueId();
        BidibScriptScanner scanner = new BidibScriptScanner();
        scanner.change(0, 0, oldLen > -1 ? oldLen : line.length());
        oldLen = line.trim().length();
        scanner.change(0, 0, line.length());
        scanner.scan(line.toCharArray(), 0, line.length());
        int index = 0;
        this.scan(scanner, index, context);
    }

    public int scan(Scanner scanner, int index, final ApplicationContext context) {
        int i;
        for (i = index + 1; i < scanner.size(); ++i) {
            Token token = scanner.getToken(i);
            LOGGER.info("scan, current index: {}, token symbol: {}, name: {}", new Object[]{i, token.symbol.type, token.symbol.name});
            block0 : switch (token.symbol.type) {
                case 12: {
                    switch (token.symbol.name) {
                        case "name": {
                            StringValueCallback labelAware = new StringValueCallback(){

                                @Override
                                public void setString(String label) {
                                    LOGGER.info("Set the port label: {}", (Object)label);
                                    ConfigPortCommand.this.portLabel = label;
                                }
                            };
                            i = NodeScriptUtils.parseLabel(scanner, i, labelAware, context);
                            break block0;
                        }
                        case "ptype": {
                            i = NodeScriptUtils.parsePtype(scanner, i, context, this);
                            break block0;
                        }
                        case "lowerlimit": {
                            LOGGER.info("LowerLimit detected: {}", (Object)token.symbol.name);
                            NumberAware lowerLimitCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the lower limit: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)7, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, lowerLimitCallback, context);
                            break block0;
                        }
                        case "upperlimit": {
                            LOGGER.info("UpperLimit detected: {}", (Object)token.symbol.name);
                            NumberAware upperLimitCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the upper limit: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)8, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, upperLimitCallback, context);
                            break block0;
                        }
                        case "turntime": {
                            LOGGER.info("TurnTime detected: {}", (Object)token.symbol.name);
                            NumberAware turnTimeCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the turntime: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)9, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, turnTimeCallback, context);
                            break block0;
                        }
                        case "valueoff": {
                            LOGGER.info("valueOff detected: {}", (Object)token.symbol.name);
                            NumberAware valueOffCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the valueOff: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)2, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, valueOffCallback, context);
                            break block0;
                        }
                        case "valueon": {
                            LOGGER.info("valueOn detected: {}", (Object)token.symbol.name);
                            NumberAware valueOnCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the valueOn: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)1, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, valueOnCallback, context);
                            break block0;
                        }
                        case "dimmoff": {
                            LOGGER.info("dimmOff detected: {}", (Object)token.symbol.name);
                            NumberAware dimmOffCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the dimmOff: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)4, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, dimmOffCallback, context);
                            break block0;
                        }
                        case "dimmon": {
                            LOGGER.info("dimmOn detected: {}", (Object)token.symbol.name);
                            NumberAware dimmOnCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the dimmOn: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)3, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, dimmOnCallback, context);
                            break block0;
                        }
                        case "dimmoff88": {
                            LOGGER.info("dimmOff88 detected: {}", (Object)token.symbol.name);
                            NumberAware dimmOff88Callback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the dimmOff: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)68, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)number))));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, dimmOff88Callback, context);
                            break block0;
                        }
                        case "dimmon88": {
                            LOGGER.info("dimmOn88 detected: {}", (Object)token.symbol.name);
                            NumberAware dimmOn88Callback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the dimmOn: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)67, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)number))));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, dimmOn88Callback, context);
                            break block0;
                        }
                        case "mapping": {
                            LOGGER.info("mapping detected: {}", (Object)token.symbol.name);
                            NumberAware mappingCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the mapping: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)6, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, mappingCallback, context);
                            break block0;
                        }
                        case "switchControl": {
                            LOGGER.info("switchControl detected: {}", (Object)token.symbol.name);
                            NumberAware switchControlCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the switchControl: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, switchControlCallback, context);
                            break block0;
                        }
                        case "ticks": {
                            LOGGER.info("ticks detected: {}", (Object)token.symbol.name);
                            NumberAware ticksCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the ticks: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put((byte)11, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, ticksCallback, context);
                            break block0;
                        }
                        case "loadtype": {
                            LOGGER.info("loadtype detected: {}", (Object)token.symbol.name);
                            NumberAware loadtypeCallback = new NumberAware(){

                                @Override
                                public void setNumber(Integer number) {
                                    LOGGER.info("Set the loadtype: {}", (Object)number);
                                    ConfigPortCommand.this.portConfig.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)number)));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, loadtypeCallback, context);
                            break block0;
                        }
                        case "number": {
                            NumberAware numberAware = new NumberAware(){

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                @Override
                                public void setNumber(Integer number) {
                                    ConfigPortCommand.this.setPortNumber(number);
                                    if (ConfigPortCommand.this.function == null) {
                                        LOGGER.warn("Unknown parameter number detected, value: {}", (Object)number);
                                        return;
                                    }
                                    if (!(ConfigPortCommand.this.function instanceof PortAction)) return;
                                    PortAction portAction = (PortAction)ConfigPortCommand.this.function;
                                    String actionKey = portAction.getKey();
                                    LOGGER.info("Set the port id: {}, actionKey: {}", (Object)number, (Object)actionKey);
                                    Integer portId = number;
                                    PortsProvider portsProvider = (PortsProvider)context.get("selectedNode", PortsProvider.class);
                                    Port port = null;
                                    switch (portAction.getKey()) {
                                        case "analog": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getAnalogPorts(), (int)portId);
                                            break;
                                        }
                                        case "backlight": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getBacklightPorts(), (int)portId);
                                            break;
                                        }
                                        case "feedback": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getFeedbackPorts(), (int)portId);
                                            break;
                                        }
                                        case "input": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getEnabledInputPorts(), (int)portId);
                                            break;
                                        }
                                        case "light": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getLightPorts(), (int)portId);
                                            break;
                                        }
                                        case "motor": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getMotorPorts(), (int)portId);
                                            break;
                                        }
                                        case "servo": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getServoPorts(), (int)portId);
                                            break;
                                        }
                                        case "sound": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getSoundPorts(), (int)portId);
                                            break;
                                        }
                                        case "switch": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getEnabledSwitchPorts(), (int)portId);
                                            break;
                                        }
                                        case "switchpair": {
                                            port = PortListUtils.findPortByPortNumber((List)portsProvider.getEnabledSwitchPairPorts(), (int)portId);
                                            break;
                                        }
                                    }
                                    if (port != null) {
                                        portAction.setPort(port);
                                        return;
                                    }
                                    LOGGER.warn("No port found for port number: {}, actionKey: {}", (Object)portId, (Object)actionKey);
                                    throw new ScriptProcessingException(String.format("No port found for port number: %1$d, actionKey: %2$s", portId, actionKey));
                                }
                            };
                            i = NodeScriptUtils.parseNumber(scanner, i, numberAware, context);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    LOGGER.info("NUMBER detected: {}", (Object)token.symbol.name);
                    this.setPortNumber(Integer.valueOf(token.symbol.name));
                    break;
                }
                case 13: {
                    LOGGER.info("IDENTIFIER detected: {}", (Object)token.symbol.name);
                    break;
                }
            }
            LOGGER.info("scan, i after parse: {}, last symbol name: {}", (Object)i, (Object)token.symbol.name);
        }
        return i;
    }

    @Override
    protected void internalExecute(NodeScripting scripting, ApplicationContext context) {
        PortAction portAction;
        LOGGER.info("Set the port config: {}", (Object)this);
        if (StringUtils.isNotEmpty((CharSequence)this.getLine())) {
            String line = this.getLine();
            this.parseAndEvaluateLine(line, context);
        }
        if (this.function == null) {
            throw new IllegalArgumentException("The function must not be null.");
        }
        String labelKey = null;
        TargetType portType = null;
        switch (this.function.getKey().toLowerCase()) {
            case "input": {
                labelKey = "inputLabels";
                portType = new InputPortType();
                break;
            }
            case "servo": {
                labelKey = "servoLabels";
                portType = new ServoPortType();
                break;
            }
            case "sound": {
                labelKey = "soundLabels";
                portType = new SoundPortType();
                break;
            }
            case "switch": {
                labelKey = "switchLabels";
                portType = new SwitchPortType();
                break;
            }
            case "switchpair": {
                labelKey = "switchPairLabels";
                portType = new SwitchPairPortType();
                break;
            }
            case "backlight": {
                labelKey = "backlightLabels";
                portType = new BacklightPortType();
                break;
            }
            case "motor": {
                labelKey = "motorLabels";
                portType = new MotorPortType();
                break;
            }
            case "light": {
                labelKey = "lightLabels";
                portType = new LightPortType();
                break;
            }
            case "feedback": {
                labelKey = "feedbackPortLabels";
                portType = new FeedbackPortType();
                break;
            }
            default: {
                LOGGER.warn("Unsupported port type for port config: {}", (Object)this.function.getAction().getKey());
            }
        }
        if (this.function instanceof PortAction && (portAction = (PortAction)this.function).getPort() != null) {
            this.portNumber = portAction.getPort().getId();
        }
        LOGGER.info("Current port number: {}", (Object)this.portNumber);
        if (this.portNumber != null) {
            portType.setPortNum(this.portNumber);
            scripting.setPortConfig(this.uuid, portType, this.portConfig);
        } else if (StringUtils.isNotBlank((CharSequence)labelKey) && StringUtils.isNotBlank((CharSequence)this.portLabel)) {
            Map labelMap = (Map)context.get(labelKey);
            Integer portNumber = (Integer)MapUtils.invertMap((Map)labelMap).get(this.portLabel);
            if (portNumber != null) {
                portType.setPortNum(portNumber);
                scripting.setPortConfig(this.uuid, portType, this.portConfig);
            } else {
                LOGGER.warn("No port number found for portLabel: {}", (Object)this.portLabel);
            }
        } else if (portType.getPortNum() != null) {
            LOGGER.info("Set the port config for portType: {}, portConfig: {}", (Object)portType, this.portConfig);
            scripting.setPortConfig(this.uuid, portType, this.portConfig);
        } else {
            LOGGER.warn("Set port config is skipped because the key for labels or no port label is not avaiable, function: {}", this.function);
        }
    }

    public void afterPropertiesSet() {
        LOGGER.info("afterPropertiesSet is called: {}", (Object)this);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

