/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.types.CvType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvGetAssertEqualsCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvGetAssertEqualsCommand.class);
    public static final String KEY = "cvGetAssertEquals";
    public static final String HELP = "<div class=\"codeblock\">cvGetAssertEquals" + CvGetAssertEqualsCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] <cvKey>=<cvValue> [<cvKey>=<cvValue> ...]") + "</div>" + CvGetAssertEqualsCommand.prepareHelpHtml("\nGet the CV value(s) and compare the read values with the provided values.");
    private int[] vidPid;
    private boolean processAllNodes;
    private final List<CvType> cvValues = new ArrayList<CvType>();

    public CvGetAssertEqualsCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                throw new IllegalArgumentException("Parse VID/PID failed.\n" + this.getHelpHtml());
            }
            if (arguments.indexOf("--all") > -1) {
                LOGGER.info("Process all nodes is activated.");
                this.processAllNodes = true;
            }
            Pattern pattern = Pattern.compile("\\w+=\\w+");
            Matcher matcher = pattern.matcher(arguments);
            while (matcher.find()) {
                String cvPair = matcher.group();
                String[] values = cvPair.split("=");
                this.cvValues.add(new CvType(values[0], values[1]));
            }
        }
        LOGGER.info("Parsed command, cvValues: {}", this.cvValues);
    }

    public List<CvType> getCvValues() {
        return Collections.unmodifiableList(this.cvValues);
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Get the cv values: {}", this.cvValues);
        ArrayList<NodeInterface> nodes = new ArrayList<NodeInterface>();
        if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                return;
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        List<CvType> cvTypes = this.cvValues;
        boolean errorDetected = false;
        Iterator iterator = nodes.iterator();
        block0: while (true) {
            if (!iterator.hasNext()) {
                if (errorDetected) {
                    throw new IllegalStateException("CV value does not match expected value!");
                }
                return;
            }
            NodeInterface node = (NodeInterface)iterator.next();
            List<ConfigurationVariable> cvReadList = scripting.getCv(node.getUniqueId(), cvTypes.toArray(new CvType[0]));
            Iterator<CvType> iterator2 = this.cvValues.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                CvType currentCv = iterator2.next();
                String cvNumber = currentCv.getCvNumber();
                ConfigurationVariable readCv = cvReadList.stream().filter(cv -> cvNumber.equals(cv.getName())).findFirst().orElse(null);
                if (readCv == null) {
                    errorDetected = true;
                    this.addError(context, "No CV value returned for CV number: " + cvNumber);
                    continue;
                }
                if (currentCv.getCvValue().equals(readCv.getValue())) continue;
                errorDetected = true;
                this.addError(context, "CV value does not match expected value, cvNumber: " + cvNumber + ", expected: " + currentCv.getCvValue() + ", read: " + readCv.getValue());
            }
            break;
        }
    }
}

