/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGetAllCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGetAllCommand.class);
    public static final String KEY = "featureGetAll";
    public static final String HELP = "<div class=\"codeblock\">featureGetAll" + FeatureGetAllCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] [--parallel=<true|false>]") + "</div>";
    private int[] vidPid;
    private boolean processAllNodes;
    private boolean processParallel;

    public FeatureGetAllCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                throw new IllegalArgumentException("Parse VID/PID failed.\n" + this.getHelpHtml());
            }
            if (arguments.indexOf("--all") > -1) {
                LOGGER.info("Process all nodes is activated.");
                this.processAllNodes = true;
            }
            try {
                String parallel = ScriptUtils.parseStringParam("--parallel=\\w+", arguments);
                if (Boolean.parseBoolean(parallel) || "yes".equalsIgnoreCase(parallel)) {
                    LOGGER.info("Process the requests parallel.");
                    this.processParallel = true;
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("The parallel argument is not provided.");
            }
        }
        LOGGER.info("Parsed command.");
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        List currentNodes;
        LOGGER.info("Get all features. Execute the requests parallel: {}", (Object)this.processParallel);
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        if (this.vidPid != null) {
            currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                return;
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else if (this.processAllNodes) {
            currentNodes = scripting.getAllNodes();
            nodes.addAll(currentNodes);
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        if (this.processParallel) {
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("featureGetAllWorkers-thread-%d").build();
            ScheduledExecutorService worker = Executors.newScheduledThreadPool(nodes.size(), namedThreadFactory);
            LOGGER.info("Fetch the features from the nodes with parallel execution.");
            try {
                for (NodeInterface node : nodes) {
                    worker.submit(() -> scripting.featuresGetAll(node.getUniqueId(), true));
                }
                return;
            }
            finally {
                try {
                    worker.shutdown();
                    worker.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    LOGGER.warn("Wait for shutdown of worker threadpool failed.", (Throwable)ex);
                }
            }
        }
        for (NodeInterface node : nodes) {
            scripting.featuresGetAll(node.getUniqueId(), true);
        }
    }
}

