/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.types.FeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureSetCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureSetCommand.class);
    public static final String KEY = "featureSet";
    public static final String HELP = "<div class=\"codeblock\">featureSet" + FeatureSetCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] <featureNumber>=<featureValue> [<featureNumber>=<featureValue> ...]") + "</div>";
    private int[] vidPid;
    private boolean processAllNodes;
    private List<FeatureType> features = new LinkedList<FeatureType>();

    public FeatureSetCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                throw new IllegalArgumentException("Parse VID/PID failed.\n" + this.getHelpHtml());
            }
            if (arguments.indexOf("--all") > -1) {
                LOGGER.info("Process all nodes is activated.");
                this.processAllNodes = true;
            }
            Pattern pattern = Pattern.compile("\\d+=\\d+");
            Matcher matcher = pattern.matcher(arguments);
            while (matcher.find()) {
                String featurePair = matcher.group();
                String[] values = featurePair.split("=");
                this.features.add(new FeatureType(Integer.parseInt(values[0]), Integer.parseInt(values[1])));
            }
        }
        LOGGER.info("Parsed command, features: {}", this.features);
    }

    public List<FeatureType> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Set the features: {}", this.features);
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                return;
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set features.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            scripting.setFeature(node.getUniqueId(), this.features.toArray(new FeatureType[0]));
        }
        return;
    }
}

