/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import java.util.Scanner;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifyStateCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifyStateCommand.class);
    public static final String KEY = "identifyState";
    public static final String HELP = "<div class=\"codeblock\">identifyState" + IdentifyStateCommand.prepareHelpHtml(" <status [ON|OFF]>") + "</div>" + IdentifyStateCommand.prepareHelpHtml("\nSet the identify state of the node.");
    private IdentifyState identifyState;

    public IdentifyStateCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.identifyState = IdentifyState.fromString((String)scanner.next().toUpperCase());
        }
        LOGGER.info("Parsed command, identifyState: {}", (Object)this.identifyState);
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Set the identify state, identifyState: {}", (Object)this.identifyState);
        NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        scripting.setIdentifyState(node.getUniqueId(), this.identifyState);
    }
}

