/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.Delayable;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.common.highlight.Scanner;
import org.bidib.wizard.common.highlight.Token;
import org.bidib.wizard.common.script.node.ActionAware;
import org.bidib.wizard.common.script.node.BooleanAware;
import org.bidib.wizard.common.script.node.FunctionAware;
import org.bidib.wizard.common.script.node.NumberAware;
import org.bidib.wizard.common.script.node.StringValueCallback;
import org.bidib.wizard.common.script.node.TargetAware;
import org.bidib.wizard.common.utils.MacroListUtils;
import org.bidib.wizard.model.status.BidibStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeScriptUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeScriptUtils.class);

    public static int parsePtype(Scanner scanner, int index, ApplicationContext context, FunctionAware command) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            LOGGER.info("Current symbol name: {}", (Object)token.symbol.name);
            String value = null;
            token = scanner.getToken(index + 2);
            switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    value = (String)context.get(variable);
                    if (value != null) break;
                    value = variable;
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the port type value: {}", (Object)value);
            Function<? extends BidibStatus> selectedFunction = null;
            NodeInterface selectedNode = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            if (selectedNode != null) {
                Function<? extends BidibStatus>[] functions;
                for (Function<? extends BidibStatus> function : functions = MacroListUtils.prepareAvailableFunctions(selectedNode)) {
                    if (!function.getKey().equalsIgnoreCase(value)) continue;
                    LOGGER.info("Found matching function: {}", function);
                    selectedFunction = function;
                    break;
                }
            } else {
                LOGGER.warn("No selected node provided.");
            }
            if (selectedFunction != null) {
                LOGGER.info("Set the selected function: {}", selectedFunction);
                command.setFunction(selectedFunction);
            }
            return index + 2;
        }
        return index;
    }

    public static int parseLabel(Scanner scanner, int index, StringValueCallback labelAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            token = scanner.getToken(index + 2);
            do {
                String value = null;
                if (token == null) break;
                LOGGER.info("Current token.symbol.type: {}, scanner.size: {}, index: {}", new Object[]{token.symbol.type, scanner.size(), index});
                switch (token.symbol.type) {
                    case 21: {
                        String variable = token.symbol.name;
                        value = (String)context.get(variable);
                        if (value != null) break;
                        value = variable;
                        break;
                    }
                    default: {
                        value = StringUtils.strip((String)token.symbol.name, (String)"\"'");
                    }
                }
                LOGGER.info("Append the label value: {}", (Object)value);
                labelAware.appendString(value);
                if ((index += 2) >= scanner.size() - 2) break;
                token = scanner.getToken(index + 2);
            } while (token.symbol.type != 11 && token.symbol.type != 12 && token.symbol.type != 17 && token.symbol.type != 1);
            return index;
        }
        return index;
    }

    public static int parseDelay(Scanner scanner, int index, Delayable delayable, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    value = (String)context.get(variable);
                    if (value != null) break;
                    value = variable;
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the delay value: {}", (Object)value);
            delayable.setDelay(Integer.valueOf(value).intValue());
            return index + 2;
        }
        return index;
    }

    public static int parseAction(Scanner scanner, int index, ActionAware actionAware, ApplicationContext context) {
        LOGGER.info("Parse action, index: {}", (Object)index);
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    value = (String)context.get(variable);
                    if (value != null) break;
                    value = variable;
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the action value: {}", (Object)value);
            Function<? extends BidibStatus> selectedFunction = actionAware.getFunction();
            if (selectedFunction != null) {
                BidibStatus[] actions;
                for (BidibStatus action : actions = selectedFunction.getAction().getValues()) {
                    LOGGER.info("Current action: {}", (Object)action);
                    if (!action.getKey().equalsIgnoreCase(value)) continue;
                    LOGGER.info("Found matching action: {}", (Object)action);
                    actionAware.setAction(action);
                    break;
                }
            }
            return index + 2;
        }
        return index;
    }

    public BidibStatus[] getActions(BidibStatus status) {
        if (status != null) {
            BidibStatus[] actions = status.getValues();
            return actions;
        }
        LOGGER.debug("No BidibStatus available.");
        return new BidibStatus[0];
    }

    public static int parseTarget(Scanner scanner, int index, TargetAware targetAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    value = (String)context.get(variable);
                    if (value != null) break;
                    value = variable;
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the delay value: {}", (Object)value);
            targetAware.setTarget(Integer.valueOf(value));
            return index + 2;
        }
        return index;
    }

    public static int parseNumber(Scanner scanner, int index, NumberAware numberAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    LOGGER.info("parseNumber will try to replace variable: {}", (Object)variable);
                    value = (String)context.get(variable);
                    if (value != null) break;
                    LOGGER.warn("No substitution for variable found.");
                    value = variable;
                    break;
                }
                case 13: {
                    LOGGER.info("Found identifier: {}", (Object)token.symbol.name);
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the number value: {}", (Object)value);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                numberAware.setNumber(Integer.valueOf(value));
            }
            return index + 2;
        }
        return index;
    }

    public static int parseBoolean(Scanner scanner, int index, BooleanAware booleanAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    LOGGER.info("parseBoolean will try to replace variable: {}", (Object)variable);
                    value = (String)context.get(variable);
                    if (value != null) break;
                    LOGGER.warn("No substitution for variable found.");
                    value = variable;
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the boolean value: {}", (Object)value);
            booleanAware.setBoolean(Boolean.valueOf(value));
            return index + 2;
        }
        return index;
    }

    public static int parseMacroTimeHour(Scanner scanner, int index, NumberAware numberAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            block0 : switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    value = (String)context.get(variable);
                    if (value != null) break;
                    LOGGER.warn("No substitution found for variable: {}", (Object)variable);
                    value = variable;
                    break;
                }
                case 13: {
                    value = token.symbol.name;
                    LOGGER.debug("Found identifier: {}", (Object)value);
                    switch (value.toLowerCase()) {
                        case "everyfull": {
                            value = "24";
                            break block0;
                        }
                        case "everyfullatday": {
                            value = "25";
                            break block0;
                        }
                    }
                    LOGGER.warn("No replacement found for value: {}", (Object)value);
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the macro time hour number value: {}", (Object)value);
            numberAware.setNumber(Integer.valueOf(value));
            return index + 2;
        }
        return index;
    }

    public static int parseMacroTimeMinute(Scanner scanner, int index, NumberAware numberAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            block0 : switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    value = (String)context.get(variable);
                    if (value != null) break;
                    LOGGER.warn("No substitution found for variable: {}", (Object)variable);
                    value = variable;
                    break;
                }
                case 13: {
                    value = token.symbol.name;
                    LOGGER.debug("Found identifier: {}", (Object)value);
                    switch (value.toLowerCase()) {
                        case "everyminute": {
                            value = "60";
                            break block0;
                        }
                        case "everyhalfhour": {
                            value = "61";
                            break block0;
                        }
                        case "everyquarter": {
                            value = "62";
                            break block0;
                        }
                    }
                    LOGGER.warn("No replacement found for value: {}", (Object)value);
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the macro time minute number value: {}", (Object)value);
            numberAware.setNumber(Integer.valueOf(value));
            return index + 2;
        }
        return index;
    }

    public static int parseMacroTimeDay(Scanner scanner, int index, NumberAware numberAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        if (token.symbol.type == 17) {
            String value = null;
            token = scanner.getToken(index + 2);
            block0 : switch (token.symbol.type) {
                case 21: {
                    String variable = token.symbol.name;
                    value = (String)context.get(variable);
                    if (value != null) break;
                    LOGGER.warn("No substitution found for variable: {}", (Object)variable);
                    value = variable;
                    break;
                }
                case 13: {
                    value = token.symbol.name;
                    LOGGER.debug("Found identifier: {}", (Object)value);
                    switch (value.toLowerCase()) {
                        case "everyday": {
                            value = "7";
                            break block0;
                        }
                    }
                    LOGGER.warn("No replacement found for value: {}", (Object)value);
                    break;
                }
                default: {
                    value = token.symbol.name;
                }
            }
            LOGGER.info("Set the macro time hour number value: {}", (Object)value);
            numberAware.setNumber(Integer.valueOf(value));
            return index + 2;
        }
        return index;
    }

    public static int parseVariable(Scanner scanner, int index, StringValueCallback labelAware, ApplicationContext context) {
        Token token = scanner.getToken(index + 1);
        LOGGER.info("parse variable, current index: {}, token symbol: {}, name: {}", new Object[]{index, token.symbol.type, token.symbol.name});
        String value = null;
        switch (token.symbol.type) {
            case 21: {
                String variable = token.symbol.name;
                value = (String)context.get("%" + variable);
                if (value != null) break;
                value = variable;
                break;
            }
            default: {
                value = token.symbol.name;
            }
        }
        if (value != null) {
            LOGGER.info("Set the variable value: {}", (Object)value);
            labelAware.setString(value);
        }
        return 1;
    }
}

