/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import java.util.Scanner;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIdentifyStateAndExpectCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryIdentifyStateAndExpectCommand.class);
    public static final String KEY = "queryIdentifyState";
    public static final String HELP = "<div class=\"codeblock\">queryIdentifyState" + QueryIdentifyStateAndExpectCommand.prepareHelpHtml(" <expectedStatus [ON|OFF]>") + "</div>" + QueryIdentifyStateAndExpectCommand.prepareHelpHtml("\nQuery the identify state and compare to expected status.\nA dialog is displayed for a maximum of 30s or when the identify state is changed.");
    private IdentifyState expectedIdentifyState;

    public QueryIdentifyStateAndExpectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            this.expectedIdentifyState = IdentifyState.fromString((String)scanner.next().toUpperCase());
        }
        LOGGER.info("Parsed command, expectedIdentifyState: {}", (Object)this.expectedIdentifyState);
    }

    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Query the identify status, expectedIdentifyState: {}", (Object)this.expectedIdentifyState);
        NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
        IdentifyState currentIdentifyState = scripting.queryIdentifyState(node.getUniqueId());
        if (this.expectedIdentifyState != currentIdentifyState) {
            LOGGER.warn("The expected identify status ({}) does not match the current status: {}", (Object)this.expectedIdentifyState, (Object)currentIdentifyState);
            throw new IllegalStateException("Identify status does not match the expected status: " + this.expectedIdentifyState + ", current status: " + currentIdentifyState);
        }
        LOGGER.info("The expected identify status matches the current status: {}", (Object)currentIdentifyState);
    }
}

