/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import com.jgoodies.common.base.Objects;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringGetAssertEqualsCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringGetAssertEqualsCommand.class);
    public static final String KEY = "stringGetAssertEquals";
    public static final String HELP = "<div class=\"codeblock\">stringGetAssertEquals" + StringGetAssertEqualsCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] --namespace=<namespace> --index=<stringId> --expectedValue=<string> \nstringGetAssertEquals [--V<vid>:P<pid>] [--all] --namespace=<namespace> --index=<stringId> --expectedValue=\"<string>\"") + "</div>" + StringGetAssertEqualsCommand.prepareHelpHtml("\nGet the string value and compare to expected value.");
    private int[] vidPid;
    private boolean processAllNodes;
    private int namespace;
    private int index;
    private String expectedValue;

    public StringGetAssertEqualsCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                throw new IllegalArgumentException("Parse VID/PID failed.\n" + this.getHelpHtml());
            }
            if (arguments.indexOf("--all") > -1) {
                LOGGER.info("Process all nodes is activated.");
                this.processAllNodes = true;
            }
            this.namespace = ScriptUtils.parseIntParam("--namespace=\\d+", arguments);
            this.index = ScriptUtils.parseIntParam("--index=\\d+", arguments);
            this.expectedValue = ScriptUtils.parseStringParam("(?<=--expectedValue=)(?s)(.*$)", arguments);
            if (this.expectedValue.length() > 40) {
                LOGGER.warn("Max length of expectedValue exceeded: {}", (Object)this.expectedValue.length());
                throw new IllegalArgumentException("Max length of expectedValue exceeded: " + this.expectedValue.length());
            }
        }
        LOGGER.info("Parsed command, namespace: {}", (Object)this.namespace);
    }

    public int getNamespace() {
        return this.namespace;
    }

    public int getIndex() {
        return this.index;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        LOGGER.info("Set the string, namespace: {}, index: {}, value: {}", new Object[]{this.namespace, this.index, this.expectedValue});
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                return;
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        boolean errorDetected = false;
        Iterator iterator = nodes.iterator();
        do {
            if (!iterator.hasNext()) {
                return;
            }
            NodeInterface node = (NodeInterface)iterator.next();
            String stringValue = scripting.getString(node.getUniqueId(), this.namespace, this.index);
            if (Objects.equals((Object)this.expectedValue, (Object)stringValue)) continue;
            errorDetected = true;
            this.addError(context, "The read string value does not match expected value, expectedValue: " + this.expectedValue + ", read: " + stringValue);
        } while (!errorDetected);
        throw new IllegalStateException("The read string value does not match expected value!");
    }
}

