/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.node;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.ScriptUtils;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSetCommand<T extends NodeScripting>
extends AbstractScriptCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringSetCommand.class);
    public static final String KEY = "stringSet";
    public static final String HELP = "<div class=\"codeblock\">stringSet" + StringSetCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] --namespace=<namespace> --index=<stringId> --value=<string> \n") + "stringSet" + StringSetCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] --namespace=<namespace> --index=<stringId> --value=\"<string>\"") + "</div>" + StringSetCommand.prepareHelpHtml("\nSet the string value.");
    private int[] vidPid;
    private boolean processAllNodes;
    private int namespace;
    private int index;
    private String value;

    public StringSetCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    public void parse(String commandLine) {
        try (Scanner scanner = new Scanner(commandLine);){
            if (!this.getKey().equals(scanner.next())) {
                LOGGER.info("Invalid command is scanned, key does not match.");
                throw new IllegalArgumentException("Invalid command is scanned, key does not match.");
            }
            this.line = commandLine.trim();
            String arguments = this.line.substring(KEY.length() + 1);
            try {
                this.vidPid = ScriptUtils.scanVidPid(scanner, true);
                if (this.vidPid != null) {
                    LOGGER.info("Current vidPid: {}:{}", (Object)this.vidPid[0], (Object)this.vidPid[1]);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("Parse VID/PID failed.", (Throwable)ex);
                throw new IllegalArgumentException("Parse VID/PID failed.\n" + this.getHelpHtml());
            }
            if (arguments.indexOf("--all") > -1) {
                LOGGER.info("Process all nodes is activated.");
                this.processAllNodes = true;
            }
            this.namespace = ScriptUtils.parseIntParam("--namespace=\\d+", arguments);
            this.index = ScriptUtils.parseIntParam("--index=\\d+", arguments);
            this.value = ScriptUtils.parseStringParam("(?<=--value=)(?s)(.*$)", arguments);
            if (this.value.length() > 40) {
                LOGGER.warn("Max length of value exceeded: {}", (Object)this.value.length());
                throw new IllegalArgumentException("Max length of value exceeded: " + this.value.length());
            }
        }
        LOGGER.info("Parsed command, namespace: {}", (Object)this.namespace);
    }

    public int getNamespace() {
        return this.namespace;
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.value;
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(T scripting, ApplicationContext context) {
        List currentNodes;
        LOGGER.info("Set the string, namespace: {}, index: {}, value: {}", new Object[]{this.namespace, this.index, this.value});
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        if (this.vidPid != null) {
            currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                return;
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else if (this.processAllNodes) {
            currentNodes = scripting.getAllNodes();
            nodes.addAll(currentNodes);
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            String returnValue = scripting.setString(node.getUniqueId(), this.namespace, this.index, this.value);
            LOGGER.info("Set string returned: {}", (Object)returnValue);
        }
        return;
    }
}

