/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.script.switching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.utils.AccessoryListUtils;
import org.bidib.wizard.common.script.AbstractScriptCommand;
import org.bidib.wizard.common.script.Holder;
import org.bidib.wizard.common.script.ScriptExecutionException;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateAndWaitForAspectCommand
extends AbstractScriptCommand<AccessoryScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivateAndWaitForAspectCommand.class);
    public static final String KEY = "activateAndWaitForAspect";
    public static final String HELP = "<div class=\"codeblock\">activateAndWaitForAspect" + ActivateAndWaitForAspectCommand.prepareHelpHtml(" [--V<vid>:P<pid>] [--all] <accessoryNumber>=<aspectNumber> <expectedResult [SUCCESSFUL|ERROR|UNKNOWN|IDLE|RUNNING> <maxWaitTime [ms]> <sleepAfterFinishTime [ms]>") + "</div>" + ActivateAndWaitForAspectCommand.prepareHelpHtml("\nActivate the aspect of accessory and compare the result.");
    private int[] vidPid;
    private boolean processAllNodes;
    private String expectedResult;
    private Integer maxWaitTime;
    private Integer sleepAfterFinishTime;
    private List<AccessoryAspectTask> taskList = new LinkedList<AccessoryAspectTask>();

    public ActivateAndWaitForAspectCommand(ConsoleService consoleService) {
        super(consoleService, KEY, HELP);
    }

    /*
     * Exception decompiling
     */
    public void parse(String commandLine) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int[] getVidPid() {
        return this.vidPid;
    }

    public boolean isProcessAllNodes() {
        return this.processAllNodes;
    }

    public List<AccessoryAspectTask> getTaskList() {
        return this.taskList;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void internalExecute(AccessoryScripting scripting, ApplicationContext context) {
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        if (this.vidPid != null) {
            List currentNodes = scripting.getNodesByVidAndPid(this.vidPid[0], this.vidPid[1]);
            if (!CollectionUtils.isNotEmpty((Collection)currentNodes)) {
                this.addError(context, "No matching node with provided VID/PID found.");
                throw new ScriptExecutionException("No matching node with provided VID/PID found.", this);
            }
            if (this.processAllNodes) {
                nodes.addAll(currentNodes);
            } else {
                nodes.add((NodeInterface)currentNodes.get(0));
            }
        } else {
            NodeInterface node = (NodeInterface)context.get("selectedNode", NodeInterface.class);
            LOGGER.info("Fetched the registered selected node: {}", (Object)node);
            nodes.add(node);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("No node selected and registered in context. Skip set CV values.");
            throw new ScriptExecutionException("No registered node in execution context.", this);
        }
        Iterator iterator = nodes.iterator();
        block0: while (iterator.hasNext()) {
            NodeInterface node = (NodeInterface)iterator.next();
            Iterator<AccessoryAspectTask> iterator2 = this.taskList.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                AccessoryAspectTask task = iterator2.next();
                this.activateAspect(scripting, context, node, task);
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAspect(AccessoryScripting scripting, ApplicationContext context, NodeInterface node, AccessoryAspectTask task) {
        StringBuilder sb;
        int accessoryNumber = task.getAccessoryNumber();
        int aspectNumber = task.getAspectNumber();
        LOGGER.info("Activate accessoryNumber: {}, aspectNumber: {}, node: {}", new Object[]{accessoryNumber, aspectNumber, node});
        final Accessory accessory = AccessoryListUtils.findAccessoryByAccessoryNumber((Iterable)node.getAccessories(), (int)accessoryNumber);
        LOGGER.info("Before activate aspect. Current accessory execution state: {}, accessoryState: {}", (Object)accessory.getAccessoryExecutionState(), (Object)accessory.getAccessoryState());
        final CountDownLatch continueLock = new CountDownLatch(1);
        final Holder executionState = new Holder();
        PropertyChangeListener accessoryListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("The accessory execution state has been changed: {}", evt.getNewValue());
                LOGGER.info("Current accessory execution state: {}, accessoryState: {}", (Object)accessory.getAccessoryExecutionState(), (Object)accessory.getAccessoryState());
                if (accessory.getAccessoryExecutionState() == AccessoryExecutionState.SUCCESSFUL || accessory.getAccessoryExecutionState() == AccessoryExecutionState.ERROR) {
                    LOGGER.info("The accessory execution state is successful or error.");
                    executionState.setValue(accessory.getAccessoryExecutionState());
                    continueLock.countDown();
                }
            }
        };
        accessory.addPropertyChangeListener("accessoryExecutionState", accessoryListener);
        scripting.setActiveAspect(node.getSwitchingNode(), accessoryNumber, aspectNumber);
        LOGGER.info("Wait for aspect: {}, maxWaitTime: {}ms, sleepAfterFinishTime: {}ms", new Object[]{aspectNumber, this.maxWaitTime, this.sleepAfterFinishTime});
        boolean isInterrupted = false;
        if (this.maxWaitTime != null) {
            CountDownLatch countDownLatch = continueLock;
            synchronized (countDownLatch) {
                try {
                    continueLock.await(this.maxWaitTime + 5, TimeUnit.MILLISECONDS);
                    LOGGER.info("Wait for aspect finished has passed.");
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for aspect finished failed.", (Throwable)ex);
                    isInterrupted = true;
                }
            }
        }
        LOGGER.info("Remove the change listener for accessory execution state.");
        accessory.removePropertyChangeListener("accessoryExecutionState", accessoryListener);
        if (continueLock.getCount() > 0L) {
            LOGGER.error("The aspect was not executed successful! Current accessoryNumber: {}, aspectNumber: {}", (Object)accessoryNumber, (Object)aspectNumber);
            sb = new StringBuilder("The aspect was not executed successful! Current accessoryNumber: ").append(accessoryNumber).append(", aspectNumber: ").append(aspectNumber);
            this.addError(context, sb.toString());
            throw new ScriptExecutionException("The result does not match the expected result.", this);
        }
        if (!this.expectedResult.equalsIgnoreCase(((AccessoryExecutionState)executionState.getValue()).name())) {
            LOGGER.error("The result does not match the expected result, expected: {}, actual: {}", (Object)this.expectedResult, (Object)((AccessoryExecutionState)executionState.getValue()).name());
            sb = new StringBuilder("The result does not match the expected result, expected: ").append(this.expectedResult).append(", actual: ").append(((AccessoryExecutionState)executionState.getValue()).name());
            this.addError(context, sb.toString());
            throw new ScriptExecutionException("The result does not match the expected result.", this);
        }
        LOGGER.info("Check the result has finished.");
        if (this.sleepAfterFinishTime != null) {
            if (!isInterrupted && !Thread.currentThread().isInterrupted()) {
                LOGGER.info("Sleep after finish: {}s", (Object)this.sleepAfterFinishTime);
                try {
                    Thread.sleep(this.sleepAfterFinishTime.longValue());
                }
                catch (Exception ex) {
                    LOGGER.warn("Sleep after finish failed.", (Throwable)ex);
                }
            } else {
                LOGGER.info("Skip sleep after finished because thread was interrupted.");
            }
        }
    }

    public static class AccessoryAspectTask {
        private final int accessoryNumber;
        private final int aspectNumber;

        public AccessoryAspectTask(int accessoryNumber, int aspectNumber) {
            this.accessoryNumber = accessoryNumber;
            this.aspectNumber = aspectNumber;
        }

        public int getAccessoryNumber() {
            return this.accessoryNumber;
        }

        public int getAspectNumber() {
            return this.aspectNumber;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

